/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.rifl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.SAXException;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.rifl.RIFLDocument;
import soot.jimple.infoflow.rifl.RIFLParser;
import soot.jimple.infoflow.source.data.AccessPathTuple;
import soot.jimple.infoflow.source.data.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.source.data.SourceSinkDefinition;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class RIFLSourceSinkDefinitionProvider
implements ISourceSinkDefinitionProvider {
    private final Set<SourceSinkDefinition> sources = new HashSet<SourceSinkDefinition>();
    private final Set<SourceSinkDefinition> sinks = new HashSet<SourceSinkDefinition>();
    private Set<SourceSinkDefinition> allMethods = null;

    public RIFLSourceSinkDefinitionProvider(String file) throws SAXException, IOException {
        RIFLParser parser2 = new RIFLParser();
        RIFLDocument doc = parser2.parseRIFL(new File(file));
        for (RIFLDocument.Assignable assign : doc.getInterfaceSpec().getSourcesSinks()) {
            this.parseRawDefinition(assign.getElement());
        }
    }

    private void parseRawDefinition(RIFLDocument.SourceSinkSpec element) {
        if (element.getType() == RIFLDocument.SourceSinkType.Source) {
            this.sources.add(this.parseDefinition(element, RIFLDocument.SourceSinkType.Source));
        } else if (element.getType() == RIFLDocument.SourceSinkType.Sink) {
            this.sinks.add(this.parseDefinition(element, RIFLDocument.SourceSinkType.Sink));
        } else if (element.getType() == RIFLDocument.SourceSinkType.Category) {
            RIFLDocument.Category cat = (RIFLDocument.Category)element;
            for (RIFLDocument.SourceSinkSpec spec : cat.getElements()) {
                this.parseRawDefinition(spec);
            }
        } else {
            throw new RuntimeException("Invalid element type");
        }
    }

    private SourceSinkDefinition parseDefinition(RIFLDocument.SourceSinkSpec element, RIFLDocument.SourceSinkType sourceSinkType) {
        if (element instanceof RIFLDocument.JavaMethodSourceSinkSpec) {
            RIFLDocument.JavaMethodSourceSinkSpec javaElement = (RIFLDocument.JavaMethodSourceSinkSpec)element;
            String methodName = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(javaElement.getHalfSignature());
            String[] parameters = SootMethodRepresentationParser.v().getParameterTypesFromSubSignature(javaElement.getHalfSignature());
            ArrayList<String> parameterTypes = new ArrayList<String>(parameters.length);
            for (String p : parameters) {
                parameterTypes.add(p);
            }
            if (element instanceof RIFLDocument.JavaParameterSpec) {
                RIFLDocument.JavaParameterSpec paramSpec = (RIFLDocument.JavaParameterSpec)element;
                Set[] parameterTuples = new Set[parameters.length];
                parameterTuples[paramSpec.getParamIdx()] = Collections.singleton(AccessPathTuple.fromPathElements(null, null, sourceSinkType == RIFLDocument.SourceSinkType.Source, sourceSinkType == RIFLDocument.SourceSinkType.Sink));
                SootMethodAndClass am = new SootMethodAndClass(methodName, javaElement.getClassName(), "", parameterTypes);
                SourceSinkDefinition def = new SourceSinkDefinition(am, null, parameterTuples, null);
                return def;
            }
            if (element instanceof RIFLDocument.JavaReturnValueSpec) {
                AccessPathTuple apt = AccessPathTuple.fromPathElements(null, null, sourceSinkType == RIFLDocument.SourceSinkType.Source, sourceSinkType == RIFLDocument.SourceSinkType.Sink);
                SootMethodAndClass am = new SootMethodAndClass(methodName, javaElement.getClassName(), "", parameterTypes);
                SourceSinkDefinition def = new SourceSinkDefinition(am, null, null, Collections.singleton(apt));
                return def;
            }
        } else if (element instanceof RIFLDocument.JavaFieldSpec) {
            // empty if block
        }
        throw new RuntimeException("Invalid source/sink specification element");
    }

    @Override
    public Set<SourceSinkDefinition> getSources() {
        return this.sources;
    }

    @Override
    public Set<SourceSinkDefinition> getSinks() {
        return this.sinks;
    }

    @Override
    public Set<SourceSinkDefinition> getAllMethods() {
        if (this.allMethods == null) {
            this.allMethods = new HashSet<SourceSinkDefinition>(this.sources.size() + this.sinks.size());
            this.allMethods.addAll(this.sources);
            this.allMethods.addAll(this.sinks);
        }
        return this.allMethods;
    }
}

