/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.fastSolver;

import heros.FlowFunction;
import heros.solver.CountingThreadPoolExecutor;
import heros.solver.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.fastSolver.InfoflowSolver;

public class BackwardsInfoflowSolver
extends InfoflowSolver {
    public BackwardsInfoflowSolver(AbstractInfoflowProblem problem, CountingThreadPoolExecutor executor) {
        super(problem, executor);
    }

    @Override
    public void injectContext(IInfoflowSolver otherSolver, SootMethod callee, Abstraction d3, Unit callSite, Abstraction d2, Abstraction d1) {
        if (!this.addIncoming(callee, d3, callSite, d1, d2)) {
            return;
        }
        Set<Pair<Unit, Abstraction>> endSumm = this.endSummary(callee, d3);
        if (endSumm != null) {
            Collection<Unit> returnSiteNs = this.icfg.getReturnSitesOfCallAt(callSite);
            for (Pair<Unit, Abstraction> entry : endSumm) {
                Unit eP = entry.getO1();
                Abstraction d4 = entry.getO2();
                for (Unit retSiteN : returnSiteNs) {
                    FlowFunction<Abstraction> retFunction = this.flowFunctions.getReturnFlowFunction(callSite, callee, eP, retSiteN);
                    for (Abstraction d5 : this.computeReturnFlowFunction(retFunction, d3, d4, callSite, (Collection<Abstraction>)Collections.singleton(d1))) {
                        if (this.memoryManager != null) {
                            d5 = this.memoryManager.handleGeneratedMemoryObject(d4, d5);
                        }
                        Abstraction d5p = d5;
                        if (d5.equals(d2)) {
                            d5p = d2;
                        } else if (this.setJumpPredecessors && d5p != d2) {
                            d5p = d5p.clone();
                            d5p.setPredecessor(d2);
                        }
                        this.propagate(d1, retSiteN, d5p, callSite, false, true);
                    }
                }
            }
        }
    }
}

