/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.fastSolver;

import com.google.common.cache.CacheBuilder;
import heros.DontSynchronize;
import heros.FlowFunction;
import heros.FlowFunctionCache;
import heros.FlowFunctions;
import heros.IFDSTabulationProblem;
import heros.SynchronizedBy;
import heros.ZeroedFlowFunctions;
import heros.solver.CountingThreadPoolExecutor;
import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.solver.IMemoryManager;
import soot.jimple.infoflow.solver.fastSolver.FastSolverLinkedNode;
import soot.jimple.infoflow.solver.fastSolver.JumpFunctions;
import soot.jimple.infoflow.solver.fastSolver.SetPoolExecutor;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public class IFDSSolver<N, D extends FastSolverLinkedNode<D, N>, M, I extends BiDiInterproceduralCFG<N, M>> {
    public static CacheBuilder<Object, Object> DEFAULT_CACHE_BUILDER = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).initialCapacity(10000).softValues();
    protected static final Logger logger = LoggerFactory.getLogger(IFDSSolver.class);
    public static final boolean DEBUG = logger.isDebugEnabled();
    protected CountingThreadPoolExecutor executor;
    @DontSynchronize(value="only used by single thread")
    protected int numThreads;
    @SynchronizedBy(value="thread safe data structure, consistent locking when used")
    protected final JumpFunctions<N, D> jumpFn;
    @SynchronizedBy(value="thread safe data structure, only modified internally")
    protected final I icfg;
    @SynchronizedBy(value="consistent lock on 'incoming'")
    protected final MyConcurrentHashMap<Pair<M, D>, Set<Pair<N, D>>> endSummary = new MyConcurrentHashMap();
    @SynchronizedBy(value="consistent lock on field")
    protected final MyConcurrentHashMap<Pair<M, D>, MyConcurrentHashMap<N, Map<D, D>>> incoming = new MyConcurrentHashMap();
    @DontSynchronize(value="stateless")
    protected final FlowFunctions<N, D, M> flowFunctions;
    @DontSynchronize(value="only used by single thread")
    protected final Map<N, Set<D>> initialSeeds;
    @DontSynchronize(value="benign races")
    public long propagationCount;
    @DontSynchronize(value="stateless")
    protected final D zeroValue;
    @DontSynchronize(value="readOnly")
    protected final FlowFunctionCache<N, D, M> ffCache;
    @DontSynchronize(value="readOnly")
    protected final boolean followReturnsPastSeeds;
    @DontSynchronize(value="readOnly")
    protected boolean setJumpPredecessors = false;
    @DontSynchronize(value="readOnly")
    private boolean enableMergePointChecking = false;
    @DontSynchronize(value="readOnly")
    protected IMemoryManager<D> memoryManager = null;

    public IFDSSolver(IFDSTabulationProblem<N, D, M, I> tabulationProblem) {
        this(tabulationProblem, DEFAULT_CACHE_BUILDER);
    }

    public IFDSSolver(IFDSTabulationProblem<N, D, M, I> tabulationProblem, CacheBuilder flowFunctionCacheBuilder) {
        FlowFunctions<N, D, M> flowFunctions;
        if (logger.isDebugEnabled()) {
            flowFunctionCacheBuilder = flowFunctionCacheBuilder.recordStats();
        }
        this.zeroValue = (FastSolverLinkedNode)tabulationProblem.zeroValue();
        this.icfg = (BiDiInterproceduralCFG)tabulationProblem.interproceduralCFG();
        FlowFunctions<N, D, M> flowFunctions2 = flowFunctions = tabulationProblem.autoAddZero() ? new ZeroedFlowFunctions<N, D, M>(tabulationProblem.flowFunctions(), this.zeroValue) : tabulationProblem.flowFunctions();
        if (flowFunctionCacheBuilder != null) {
            this.ffCache = new FlowFunctionCache<N, D, M>(flowFunctions, flowFunctionCacheBuilder);
            flowFunctions = this.ffCache;
        } else {
            this.ffCache = null;
        }
        this.flowFunctions = flowFunctions;
        this.initialSeeds = tabulationProblem.initialSeeds();
        this.jumpFn = new JumpFunctions();
        this.followReturnsPastSeeds = tabulationProblem.followReturnsPastSeeds();
        this.numThreads = Math.max(1, tabulationProblem.numThreads());
        this.executor = this.getExecutor();
    }

    public void solve() {
        this.submitInitialSeeds();
        this.awaitCompletionComputeValuesAndShutdown();
    }

    protected void submitInitialSeeds() {
        for (Map.Entry<N, Set<D>> seed : this.initialSeeds.entrySet()) {
            N startPoint = seed.getKey();
            for (FastSolverLinkedNode val : seed.getValue()) {
                this.propagate(this.zeroValue, startPoint, val, null, false);
            }
            this.jumpFn.addFunction(new PathEdge<N, D>(this.zeroValue, startPoint, this.zeroValue));
        }
    }

    protected void awaitCompletionComputeValuesAndShutdown() {
        this.runExecutorAndAwaitCompletion();
        if (logger.isDebugEnabled()) {
            this.printStats();
        }
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void runExecutorAndAwaitCompletion() {
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Throwable exception = this.executor.getException();
        if (exception != null) {
            throw new RuntimeException("There were exceptions during IFDS analysis. Exiting.", exception);
        }
    }

    protected void scheduleEdgeProcessing(PathEdge<N, D> edge) {
        if (this.executor.isTerminating()) {
            return;
        }
        this.executor.execute(new PathEdgeProcessingTask(edge));
        ++this.propagationCount;
    }

    private void processCall(PathEdge<N, D> edge) {
        FastSolverLinkedNode d1 = (FastSolverLinkedNode)edge.factAtSource();
        N n = edge.getTarget();
        FastSolverLinkedNode d2 = (FastSolverLinkedNode)edge.factAtTarget();
        assert (d2 != null);
        Collection<N> returnSiteNs = this.icfg.getReturnSitesOfCallAt(n);
        Collection callees = this.icfg.getCalleesOfCallAt(n);
        for (Object sCalledProcN : callees) {
            FlowFunction<D> function = this.flowFunctions.getCallFlowFunction(n, sCalledProcN);
            Set<FastSolverLinkedNode> res = this.computeCallFlowFunction(function, d1, d2);
            Collection startPointsOf = this.icfg.getStartPointsOf(sCalledProcN);
            for (FastSolverLinkedNode d3 : res) {
                Set<Pair<N, FastSolverLinkedNode>> endSumm;
                if (this.memoryManager != null) {
                    d3 = this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                }
                if (d3 == null) continue;
                for (Object sP : startPointsOf) {
                    this.propagate(d3, sP, d3, n, false, true);
                }
                if (!this.addIncoming(sCalledProcN, d3, n, d1, d2) || (endSumm = this.endSummary(sCalledProcN, d3)) == null || endSumm.isEmpty()) continue;
                for (Pair<N, FastSolverLinkedNode> entry : endSumm) {
                    N eP = entry.getO1();
                    FastSolverLinkedNode d4 = entry.getO2();
                    for (N retSiteN : returnSiteNs) {
                        FlowFunction<D> retFunction = this.flowFunctions.getReturnFlowFunction(n, sCalledProcN, eP, retSiteN);
                        for (FastSolverLinkedNode d5 : this.computeReturnFlowFunction(retFunction, d3, d4, n, Collections.singleton(d1))) {
                            if (this.memoryManager != null) {
                                d5 = this.memoryManager.handleGeneratedMemoryObject(d4, d5);
                            }
                            FastSolverLinkedNode d5p = d5;
                            if (d5.equals(d2)) {
                                d5p = d2;
                            } else if (this.setJumpPredecessors && d5p != d2) {
                                d5p = (FastSolverLinkedNode)d5p.clone();
                                d5p.setPredecessor(d2);
                            }
                            this.propagate(d1, retSiteN, d5p, n, false, true);
                        }
                    }
                }
            }
        }
        for (Object returnSiteN : returnSiteNs) {
            FlowFunction<D> callToReturnFlowFunction = this.flowFunctions.getCallToReturnFlowFunction(n, returnSiteN);
            for (FastSolverLinkedNode d3 : this.computeCallToReturnFlowFunction(callToReturnFlowFunction, d1, d2)) {
                if (this.memoryManager != null) {
                    d3 = this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                }
                if (d3 == null) continue;
                this.propagate(d1, returnSiteN, d3, n, false);
            }
        }
    }

    protected Set<D> computeCallFlowFunction(FlowFunction<D> callFlowFunction, D d1, D d2) {
        return callFlowFunction.computeTargets(d2);
    }

    protected Set<D> computeCallToReturnFlowFunction(FlowFunction<D> callToReturnFlowFunction, D d1, D d2) {
        return callToReturnFlowFunction.computeTargets(d2);
    }

    protected void processExit(PathEdge<N, D> edge) {
        Set<FastSolverLinkedNode> targets;
        FlowFunction<D> retFunction;
        FastSolverLinkedNode d2;
        FastSolverLinkedNode d1;
        N n = edge.getTarget();
        Object methodThatNeedsSummary = this.icfg.getMethodOf(n);
        if (!this.addEndSummary(methodThatNeedsSummary, d1 = (FastSolverLinkedNode)edge.factAtSource(), n, d2 = (FastSolverLinkedNode)edge.factAtTarget())) {
            return;
        }
        Map<N, Map<FastSolverLinkedNode, FastSolverLinkedNode>> inc = this.incoming(d1, methodThatNeedsSummary);
        if (inc != null) {
            for (Map.Entry<N, Map<FastSolverLinkedNode, FastSolverLinkedNode>> entry : inc.entrySet()) {
                N c = entry.getKey();
                Set<FastSolverLinkedNode> callerSideDs = entry.getValue().keySet();
                for (N retSiteC : this.icfg.getReturnSitesOfCallAt(c)) {
                    retFunction = this.flowFunctions.getReturnFlowFunction(c, methodThatNeedsSummary, n, retSiteC);
                    targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, callerSideDs);
                    for (Map.Entry<FastSolverLinkedNode, FastSolverLinkedNode> d1d2entry : entry.getValue().entrySet()) {
                        FastSolverLinkedNode d4 = d1d2entry.getKey();
                        FastSolverLinkedNode predVal = d1d2entry.getValue();
                        for (FastSolverLinkedNode d5 : targets) {
                            if (this.memoryManager != null) {
                                d5 = this.memoryManager.handleGeneratedMemoryObject(d2, d5);
                            }
                            if (d5 == null) continue;
                            FastSolverLinkedNode d5p = d5;
                            if (d5.equals(predVal)) {
                                d5p = predVal;
                            } else if (this.setJumpPredecessors && d5p != predVal) {
                                d5p = (FastSolverLinkedNode)d5p.clone();
                                d5p.setPredecessor(predVal);
                            }
                            this.propagate(d4, retSiteC, d5p, c, false, true);
                        }
                    }
                }
            }
        }
        if (this.followReturnsPastSeeds && d1 == this.zeroValue && (inc == null || inc.isEmpty())) {
            Collection callers = this.icfg.getCallersOf(methodThatNeedsSummary);
            for (N c : callers) {
                Object callerMethod = this.icfg.getMethodOf(c);
                for (N retSiteC : this.icfg.getReturnSitesOfCallAt(c)) {
                    retFunction = this.flowFunctions.getReturnFlowFunction(c, methodThatNeedsSummary, n, retSiteC);
                    targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, Collections.singleton(this.zeroValue));
                    for (FastSolverLinkedNode d5 : targets) {
                        if (this.memoryManager != null) {
                            d5 = this.memoryManager.handleGeneratedMemoryObject(d2, d5);
                        }
                        if (d5 == null) continue;
                        this.propagate(this.zeroValue, retSiteC, d5, c, true, callerMethod == methodThatNeedsSummary);
                    }
                }
            }
            if (callers.isEmpty()) {
                FlowFunction<FastSolverLinkedNode> flowFunction = this.flowFunctions.getReturnFlowFunction(null, methodThatNeedsSummary, n, null);
                flowFunction.computeTargets(d2);
            }
        }
    }

    protected Set<D> computeReturnFlowFunction(FlowFunction<D> retFunction, D d1, D d2, N callSite, Collection<D> callerSideDs) {
        return retFunction.computeTargets(d2);
    }

    private void processNormalFlow(PathEdge<N, D> edge) {
        FastSolverLinkedNode d1 = (FastSolverLinkedNode)edge.factAtSource();
        N n = edge.getTarget();
        FastSolverLinkedNode d2 = (FastSolverLinkedNode)edge.factAtTarget();
        for (N m : this.icfg.getSuccsOf(n)) {
            FlowFunction<D> flowFunction = this.flowFunctions.getNormalFlowFunction(n, m);
            Set<FastSolverLinkedNode> res = this.computeNormalFlowFunction(flowFunction, d1, d2);
            for (FastSolverLinkedNode d3 : res) {
                if (this.memoryManager != null && d2 != d3) {
                    d3 = this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                }
                if (d3 == null) continue;
                this.propagate(d1, m, d3, null, false);
            }
        }
    }

    protected Set<D> computeNormalFlowFunction(FlowFunction<D> flowFunction, D d1, D d2) {
        return flowFunction.computeTargets(d2);
    }

    protected void propagate(D sourceVal, N target, D targetVal, N relatedCallSite, boolean isUnbalancedReturn) {
        this.propagate(sourceVal, target, targetVal, relatedCallSite, isUnbalancedReturn, false);
    }

    protected void propagate(D sourceVal, N target, D targetVal, N relatedCallSite, boolean isUnbalancedReturn, boolean forceRegister) {
        FastSolverLinkedNode existingVal;
        if (this.memoryManager != null) {
            sourceVal = (FastSolverLinkedNode)this.memoryManager.handleMemoryObject(sourceVal);
            targetVal = (FastSolverLinkedNode)this.memoryManager.handleMemoryObject(targetVal);
            if (sourceVal == null || targetVal == null) {
                return;
            }
        }
        PathEdge<N, D> edge = new PathEdge<N, D>(sourceVal, target, targetVal);
        FastSolverLinkedNode fastSolverLinkedNode = existingVal = forceRegister || !this.enableMergePointChecking || this.isMergePoint(target) ? (FastSolverLinkedNode)this.jumpFn.addFunction(edge) : null;
        if (existingVal != null) {
            if (existingVal != targetVal) {
                existingVal.addNeighbor(targetVal);
            }
        } else {
            this.scheduleEdgeProcessing(edge);
        }
    }

    private boolean isMergePoint(N target) {
        List<N> preds = this.icfg.getPredsOf(target);
        int size = preds.size();
        if (size > 1 && !this.icfg.getEndPointsOf(this.icfg.getMethodOf(target)).contains(target)) {
            return true;
        }
        return size == 1 && this.icfg.getStartPointsOf(this.icfg.getMethodOf(target)).contains(target) && !this.icfg.getEndPointsOf(this.icfg.getMethodOf(target)).contains(target);
    }

    protected Set<Pair<N, D>> endSummary(M m, D d3) {
        Set map = (Set)this.endSummary.get(new Pair<M, D>(m, d3));
        return map;
    }

    private boolean addEndSummary(M m, D d1, N eP, D d2) {
        if (d1 == this.zeroValue) {
            return true;
        }
        Set summaries = this.endSummary.putIfAbsentElseGet(new Pair<M, D>(m, d1), new ConcurrentHashSet());
        return summaries.add(new Pair<N, D>(eP, d2));
    }

    protected Map<N, Map<D, D>> incoming(D d1, M m) {
        Map map = (Map)this.incoming.get(new Pair<M, D>(m, d1));
        return map;
    }

    protected boolean addIncoming(M m, D d3, N n, D d1, D d2) {
        MyConcurrentHashMap summaries = this.incoming.putIfAbsentElseGet(new Pair<M, D>(m, d3), new MyConcurrentHashMap());
        Map set = summaries.putIfAbsentElseGet(n, new ConcurrentHashMap());
        return set.put(d1, d2) == null;
    }

    protected CountingThreadPoolExecutor getExecutor() {
        return new SetPoolExecutor(1, this.numThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    protected String getDebugName() {
        return "FAST IFDS SOLVER";
    }

    public void printStats() {
        if (logger.isDebugEnabled()) {
            if (this.ffCache != null) {
                this.ffCache.printStats();
            }
        } else {
            logger.info("No statistics were collected, as DEBUG is disabled.");
        }
    }

    public void setJumpPredecessors(boolean setJumpPredecessors) {
        this.setJumpPredecessors = setJumpPredecessors;
    }

    public void setEnableMergePointChecking(boolean enableMergePointChecking) {
        this.enableMergePointChecking = enableMergePointChecking;
    }

    public void setMemoryManager(IMemoryManager<D> memoryManager) {
        this.memoryManager = memoryManager;
    }

    public IMemoryManager<D> getMemoryManager() {
        return this.memoryManager;
    }

    private class PathEdgeProcessingTask
    implements Runnable {
        private final PathEdge<N, D> edge;

        public PathEdgeProcessingTask(PathEdge<N, D> edge) {
            this.edge = edge;
        }

        @Override
        public void run() {
            if (IFDSSolver.this.icfg.isCallStmt(this.edge.getTarget())) {
                IFDSSolver.this.processCall(this.edge);
            } else {
                if (IFDSSolver.this.icfg.isExitStmt(this.edge.getTarget())) {
                    IFDSSolver.this.processExit(this.edge);
                }
                if (!IFDSSolver.this.icfg.getSuccsOf(this.edge.getTarget()).isEmpty()) {
                    IFDSSolver.this.processNormalFlow(this.edge);
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.edge == null ? 0 : this.edge.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathEdgeProcessingTask other = (PathEdgeProcessingTask)obj;
            return !(this.edge == null ? other.edge != null : !this.edge.equals(other.edge));
        }
    }
}

