/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.heros;

import com.google.common.collect.Table;
import heros.EdgeFunction;
import heros.FlowFunction;
import heros.edgefunc.EdgeIdentity;
import heros.solver.CountingThreadPoolExecutor;
import heros.solver.IFDSSolver;
import heros.solver.JumpFunctions;
import heros.solver.Pair;
import heros.solver.PathEdge;
import heros.solver.PathTrackingIFDSSolver;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.IFollowReturnsPastSeedsHandler;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.IMemoryManager;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public class InfoflowSolver
extends PathTrackingIFDSSolver<Unit, Abstraction, SootMethod, BiDiInterproceduralCFG<Unit, SootMethod>>
implements IInfoflowSolver {
    private IFollowReturnsPastSeedsHandler followReturnsPastSeedsHandler = null;

    public InfoflowSolver(AbstractInfoflowProblem problem, CountingThreadPoolExecutor executor) {
        super(problem);
        this.executor = executor;
        problem.setSolver(this);
    }

    @Override
    protected CountingThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean processEdge(PathEdge<Unit, Abstraction> edge) {
        if (!this.jumpFn.forwardLookup(edge.factAtSource(), edge.getTarget()).containsKey(edge.factAtTarget())) {
            this.propagate(edge.factAtSource(), edge.getTarget(), edge.factAtTarget(), EdgeIdentity.v(), null, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectContext(IInfoflowSolver otherSolver, SootMethod callee, Abstraction d3, Unit callSite, Abstraction d2, Abstraction d1) {
        HashSet<Abstraction> otherAbstractions;
        if (!(otherSolver instanceof InfoflowSolver)) {
            throw new RuntimeException("Other solver must be of same type");
        }
        Table table = this.incoming;
        synchronized (table) {
            for (Unit sP : ((BiDiInterproceduralCFG)this.icfg).getStartPointsOf(callee)) {
                this.addIncoming(sP, d3, callSite, d2);
            }
        }
        InfoflowSolver solver = (InfoflowSolver)otherSolver;
        JumpFunctions jumpFunctions = solver.jumpFn;
        synchronized (jumpFunctions) {
            otherAbstractions = new HashSet<Abstraction>(solver.jumpFn.reverseLookup(callSite, d2).keySet());
        }
        for (Abstraction dx1 : otherAbstractions) {
            if (dx1.getAccessPath().isEmpty() || dx1.getAccessPath().isStaticFieldRef()) continue;
            this.processEdge(new PathEdge<Unit, Abstraction>(d1, callSite, d2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<Abstraction> computeReturnFlowFunction(FlowFunction<Abstraction> retFunction, Abstraction d1, Abstraction d2, Unit callSite, Set<Abstraction> callerSideDs) {
        if (retFunction instanceof SolverReturnFlowFunction) {
            HashSet<Abstraction> d1s = new HashSet<Abstraction>(callerSideDs.size() * 5);
            for (Abstraction d4 : callerSideDs) {
                if (d4 == this.zeroValue) {
                    d1s.add(d4);
                    continue;
                }
                JumpFunctions jumpFunctions = this.jumpFn;
                synchronized (jumpFunctions) {
                    d1s.addAll(this.jumpFn.reverseLookup(callSite, d4).keySet());
                }
            }
            return ((SolverReturnFlowFunction)retFunction).computeTargets(d2, d1, d1s);
        }
        return retFunction.computeTargets(d2);
    }

    @Override
    protected Set<Abstraction> computeNormalFlowFunction(FlowFunction<Abstraction> flowFunction, Abstraction d1, Abstraction d2) {
        if (flowFunction instanceof SolverNormalFlowFunction) {
            return ((SolverNormalFlowFunction)flowFunction).computeTargets(d1, d2);
        }
        return flowFunction.computeTargets(d2);
    }

    @Override
    protected Set<Abstraction> computeCallToReturnFlowFunction(FlowFunction<Abstraction> flowFunction, Abstraction d1, Abstraction d2) {
        if (flowFunction instanceof SolverCallToReturnFlowFunction) {
            return ((SolverCallToReturnFlowFunction)flowFunction).computeTargets(d1, d2);
        }
        return flowFunction.computeTargets(d2);
    }

    @Override
    protected Set<Abstraction> computeCallFlowFunction(FlowFunction<Abstraction> flowFunction, Abstraction d1, Abstraction d2) {
        if (flowFunction instanceof SolverCallFlowFunction) {
            return ((SolverCallFlowFunction)flowFunction).computeTargets(d1, d2);
        }
        return flowFunction.computeTargets(d2);
    }

    @Override
    protected void propagate(Abstraction sourceVal, Unit target, Abstraction targetVal, EdgeFunction<IFDSSolver.BinaryDomain> f, Unit relatedCallSite, boolean isUnbalancedReturn) {
        boolean noProp = false;
        if (!noProp) {
            super.propagate(sourceVal, target, targetVal, f, relatedCallSite, isUnbalancedReturn);
        }
    }

    @Override
    public void cleanup() {
        this.jumpFn.clear();
        this.incoming.clear();
        this.endSummary.clear();
        this.val.clear();
        this.cache.clear();
    }

    @Override
    public Set<Pair<Unit, Abstraction>> endSummary(SootMethod m, Abstraction d3) {
        HashSet<Pair<Unit, Abstraction>> res = null;
        for (Unit sP : ((BiDiInterproceduralCFG)this.icfg).getStartPointsOf(m)) {
            Set endSum = super.endSummary(sP, d3);
            if (endSum == null || endSum.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<Pair<Unit, Abstraction>>();
            }
            for (Table.Cell cell : endSum) {
                res.add(new Pair<Unit, Abstraction>(cell.getRowKey(), cell.getColumnKey()));
            }
        }
        return res;
    }

    @Override
    protected void processExit(PathEdge<Unit, Abstraction> edge) {
        super.processExit(edge);
        if (this.followReturnsPastSeeds && this.followReturnsPastSeedsHandler != null) {
            Abstraction d1 = edge.factAtSource();
            Unit u = edge.getTarget();
            Abstraction d2 = edge.factAtTarget();
            SootMethod methodThatNeedsSummary = (SootMethod)((BiDiInterproceduralCFG)this.icfg).getMethodOf(u);
            for (Unit sP : ((BiDiInterproceduralCFG)this.icfg).getStartPointsOf(methodThatNeedsSummary)) {
                Map<Unit, Set<Abstraction>> inc = this.incoming(d1, sP);
                if (inc != null && !inc.isEmpty()) continue;
                this.followReturnsPastSeedsHandler.handleFollowReturnsPastSeeds(d1, u, d2);
            }
        }
    }

    @Override
    public void setFollowReturnsPastSeedsHandler(IFollowReturnsPastSeedsHandler handler) {
        this.followReturnsPastSeedsHandler = handler;
    }

    @Override
    public IMemoryManager<Abstraction> getMemoryManager() {
        return null;
    }
}

