/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.source.data;

import java.util.Arrays;
import soot.jimple.infoflow.source.data.SinkSource;

public class AccessPathTuple {
    private String[] fields;
    private String[] fieldTypes;
    private SinkSource sinkSource;

    AccessPathTuple(String[] fields, String[] fieldTypes, SinkSource sinkSource) {
        this.fields = fields;
        this.fieldTypes = fieldTypes;
        this.sinkSource = sinkSource;
    }

    public static AccessPathTuple fromPathElements(String[] fields, String[] fieldTypes, boolean isSource, boolean isSink) {
        SinkSource sinkSource = SinkSource.None;
        if (isSource && isSink) {
            sinkSource = SinkSource.Both;
        } else if (isSource) {
            sinkSource = SinkSource.Source;
        } else if (isSink) {
            sinkSource = SinkSource.Sink;
        }
        return new AccessPathTuple(fields, fieldTypes, sinkSource);
    }

    public String[] getFields() {
        return this.fields;
    }

    public String[] getFieldTypes() {
        return this.fieldTypes;
    }

    public SinkSource getSinkSource() {
        return this.sinkSource;
    }

    public boolean isSource() {
        return this.sinkSource == SinkSource.Source || this.sinkSource == SinkSource.Both;
    }

    public boolean isSink() {
        return this.sinkSource == SinkSource.Sink || this.sinkSource == SinkSource.Both;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fieldTypes);
        result = 31 * result + Arrays.hashCode(this.fields);
        result = 31 * result + (this.sinkSource == null ? 0 : this.sinkSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPathTuple other = (AccessPathTuple)obj;
        if (!Arrays.equals(this.fieldTypes, other.fieldTypes)) {
            return false;
        }
        if (!Arrays.equals(this.fields, other.fields)) {
            return false;
        }
        return this.sinkSource == other.sinkSource;
    }
}

