/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.taintWrappers;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;

public abstract class AbstractTaintWrapper
implements ITaintPropagationWrapper {
    protected InfoflowManager manager;
    private final AtomicInteger wrapperHits = new AtomicInteger(0);
    private final AtomicInteger wrapperMisses = new AtomicInteger(0);

    @Override
    public void initialize(InfoflowManager manager) {
        this.manager = manager;
    }

    protected abstract boolean isExclusiveInternal(Stmt var1, AccessPath var2);

    public abstract Set<AccessPath> getTaintsForMethodInternal(Stmt var1, AccessPath var2);

    @Override
    public boolean isExclusive(Stmt stmt, Abstraction taintedPath) {
        if (this.isExclusiveInternal(stmt, taintedPath.getAccessPath())) {
            this.wrapperHits.incrementAndGet();
            return true;
        }
        this.wrapperMisses.incrementAndGet();
        return false;
    }

    @Override
    public Set<Abstraction> getTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        Set<AccessPath> aps = this.getTaintsForMethodInternal(stmt, taintedPath.getAccessPath());
        if (aps == null || aps.isEmpty()) {
            return null;
        }
        HashSet<Abstraction> res = new HashSet<Abstraction>(aps.size());
        for (AccessPath ap : aps) {
            if (ap == taintedPath.getAccessPath()) {
                res.add(taintedPath);
                continue;
            }
            res.add(taintedPath.deriveNewAbstraction(ap, stmt));
        }
        return res;
    }

    @Override
    public int getWrapperHits() {
        return this.wrapperHits.get();
    }

    @Override
    public int getWrapperMisses() {
        return this.wrapperMisses.get();
    }
}

