/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.taintWrappers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.TwoElementSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.taintWrappers.AbstractTaintWrapper;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;

public class EasyTaintWrapper
extends AbstractTaintWrapper
implements Cloneable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Set<String>> classList;
    private final Map<String, Set<String>> excludeList;
    private final Map<String, Set<String>> killList;
    private final Set<String> includeList;
    private LoadingCache<SootMethod, MethodWrapType> methodWrapCache = CacheBuilder.newBuilder().build(new CacheLoader<SootMethod, MethodWrapType>(){

        @Override
        public MethodWrapType load(SootMethod arg0) throws Exception {
            return EasyTaintWrapper.this.getMethodWrapType(arg0.getSubSignature(), arg0.getDeclaringClass());
        }
    });
    private boolean aggressiveMode = false;
    private boolean alwaysModelEqualsHashCode = true;

    public EasyTaintWrapper(Map<String, Set<String>> classList) {
        this(classList, new HashMap<String, Set<String>>(), new HashMap<String, Set<String>>(), new HashSet<String>());
    }

    public EasyTaintWrapper(Map<String, Set<String>> classList, Map<String, Set<String>> excludeList) {
        this(classList, excludeList, new HashMap<String, Set<String>>(), new HashSet<String>());
    }

    public EasyTaintWrapper(Map<String, Set<String>> classList, Map<String, Set<String>> excludeList, Map<String, Set<String>> killList) {
        this(classList, excludeList, killList, new HashSet<String>());
    }

    public EasyTaintWrapper(Map<String, Set<String>> classList, Map<String, Set<String>> excludeList, Map<String, Set<String>> killList, Set<String> includeList) {
        this.classList = classList;
        this.excludeList = excludeList;
        this.killList = killList;
        this.includeList = includeList;
    }

    public EasyTaintWrapper(String f) throws IOException {
        this(new File(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EasyTaintWrapper(File f) throws IOException {
        try (BufferedReader reader = null;){
            FileReader freader = new FileReader(f);
            reader = new BufferedReader(freader);
            String line = reader.readLine();
            LinkedList<String> methodList = new LinkedList<String>();
            LinkedList<String> excludeList = new LinkedList<String>();
            LinkedList<String> killList = new LinkedList<String>();
            this.includeList = new HashSet<String>();
            while (line != null) {
                if (!line.isEmpty() && !line.startsWith("%")) {
                    if (line.startsWith("~")) {
                        excludeList.add(line.substring(1));
                    } else if (line.startsWith("-")) {
                        killList.add(line.substring(1));
                    } else if (line.startsWith("^")) {
                        this.includeList.add(line.substring(1));
                    } else {
                        methodList.add(line);
                    }
                }
                line = reader.readLine();
            }
            this.classList = SootMethodRepresentationParser.v().parseClassNames(methodList, true);
            this.excludeList = SootMethodRepresentationParser.v().parseClassNames(excludeList, true);
            this.killList = SootMethodRepresentationParser.v().parseClassNames(killList, true);
            this.logger.info("Loaded wrapper entries for {} classes and {} exclusions.", (Object)this.classList.size(), (Object)excludeList.size());
        }
    }

    public EasyTaintWrapper(EasyTaintWrapper taintWrapper) {
        this(taintWrapper.classList, taintWrapper.excludeList, taintWrapper.killList, taintWrapper.includeList);
    }

    @Override
    public Set<AccessPath> getTaintsForMethodInternal(Stmt stmt, AccessPath taintedPath) {
        boolean isSupported;
        boolean taintEqualsHashCode;
        if (!stmt.containsInvokeExpr()) {
            return Collections.emptySet();
        }
        HashSet<AccessPath> taints = new HashSet<AccessPath>();
        SootMethod method = stmt.getInvokeExpr().getMethod();
        if (!(!method.isPhantom() && method.hasActiveBody() || !taintedPath.isStaticFieldRef() && stmt instanceof DefinitionStmt && ((DefinitionStmt)stmt).getLeftOp() == taintedPath.getPlainValue())) {
            taints.add(taintedPath);
        }
        if (taintedPath.isStaticFieldRef()) {
            return Collections.singleton(taintedPath);
        }
        String subSig = stmt.getInvokeExpr().getMethodRef().getSubSignature().getString();
        boolean bl = taintEqualsHashCode = this.alwaysModelEqualsHashCode && (subSig.equals("boolean equals(java.lang.Object)") || subSig.equals("int hashCode()"));
        if (!taintedPath.isEmpty() && method.getDeclaringClass().getName().equals("java.lang.String") && subSig.equals("void getChars(int,int,char[],int)")) {
            return this.handleStringGetChars(stmt.getInvokeExpr(), taintedPath);
        }
        boolean bl2 = isSupported = this.includeList == null || this.includeList.isEmpty();
        if (!isSupported) {
            for (String supportedClass : this.includeList) {
                if (!method.getDeclaringClass().getName().startsWith(supportedClass)) continue;
                isSupported = true;
                break;
            }
        }
        if (!(isSupported || this.aggressiveMode || taintEqualsHashCode)) {
            return taints;
        }
        MethodWrapType wrapType = this.methodWrapCache.getUnchecked(method);
        if (stmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iiExpr = (InstanceInvokeExpr)stmt.getInvokeExpr();
            if (taintedPath.isEmpty() || iiExpr.getBase().equals(taintedPath.getPlainValue())) {
                if (wrapType == MethodWrapType.KillTaint) {
                    return Collections.emptySet();
                }
                if (stmt instanceof DefinitionStmt) {
                    DefinitionStmt def = (DefinitionStmt)stmt;
                    if (wrapType != MethodWrapType.Exclude && SystemClassHandler.isTaintVisible(taintedPath, method)) {
                        taints.add(AccessPathFactory.v().createAccessPath(def.getLeftOp(), true));
                    }
                }
                taints.add(taintedPath);
            }
        }
        if (isSupported && wrapType == MethodWrapType.CreateTaint) {
            boolean doTaint = taintedPath.isEmpty();
            if (!doTaint) {
                for (Value param : stmt.getInvokeExpr().getArgs()) {
                    if (!param.equals(taintedPath.getPlainValue()) || taintEqualsHashCode) continue;
                    doTaint = true;
                    break;
                }
            }
            if (doTaint) {
                if (stmt instanceof DefinitionStmt) {
                    taints.add(AccessPathFactory.v().createAccessPath(((DefinitionStmt)stmt).getLeftOp(), true));
                }
                if (stmt.getInvokeExprBox().getValue() instanceof InstanceInvokeExpr) {
                    taints.add(AccessPathFactory.v().createAccessPath(((InstanceInvokeExpr)stmt.getInvokeExprBox().getValue()).getBase(), true));
                }
                taints.add(taintedPath);
            }
        }
        return taints;
    }

    private Set<AccessPath> handleStringGetChars(InvokeExpr invokeExpr, AccessPath taintedPath) {
        if (((InstanceInvokeExpr)invokeExpr).getBase() == taintedPath.getPlainValue()) {
            return new TwoElementSet<AccessPath>(taintedPath, AccessPathFactory.v().createAccessPath(invokeExpr.getArg(2), true));
        }
        return Collections.singleton(taintedPath);
    }

    private boolean hasWrappedMethodsForClass(SootClass parentClass, boolean newTaints, boolean killTaints, boolean excludeTaints) {
        if (newTaints && this.classList.containsKey(parentClass.getName())) {
            return true;
        }
        if (excludeTaints && this.excludeList.containsKey(parentClass.getName())) {
            return true;
        }
        return killTaints && this.killList.containsKey(parentClass.getName());
    }

    private MethodWrapType getMethodWrapType(String subSig, SootClass parentClass) {
        boolean isSupported = false;
        for (String supportedClass : this.includeList) {
            if (!parentClass.getName().startsWith(supportedClass)) continue;
            isSupported = true;
            break;
        }
        if (this.alwaysModelEqualsHashCode && (subSig.equals("boolean equals(java.lang.Object)") || subSig.equals("int hashCode()"))) {
            return MethodWrapType.CreateTaint;
        }
        if (!isSupported) {
            return MethodWrapType.NotRegistered;
        }
        if (parentClass.isInterface()) {
            return this.getInterfaceWrapType(subSig, parentClass);
        }
        List<SootClass> superclasses = Scene.v().getActiveHierarchy().getSuperclassesOfIncluding(parentClass);
        for (SootClass sclass : superclasses) {
            MethodWrapType wtClass = this.getMethodWrapTypeDirect(sclass.getName(), subSig);
            if (wtClass != MethodWrapType.NotRegistered) {
                return wtClass;
            }
            for (SootClass ifc : sclass.getInterfaces()) {
                MethodWrapType wtIface = this.getInterfaceWrapType(subSig, ifc);
                if (wtIface == MethodWrapType.NotRegistered) continue;
                return wtIface;
            }
        }
        return MethodWrapType.NotRegistered;
    }

    private MethodWrapType getMethodWrapTypeDirect(String className, String subSignature) {
        if (this.alwaysModelEqualsHashCode && (subSignature.equals("boolean equals(java.lang.Object)") || subSignature.equals("int hashCode()"))) {
            return MethodWrapType.CreateTaint;
        }
        Set<String> cEntries = this.classList.get(className);
        Set<String> eEntries = this.excludeList.get(className);
        Set<String> kEntries = this.killList.get(className);
        if (cEntries != null && cEntries.contains(subSignature)) {
            return MethodWrapType.CreateTaint;
        }
        if (eEntries != null && eEntries.contains(subSignature)) {
            return MethodWrapType.Exclude;
        }
        if (kEntries != null && kEntries.contains(subSignature)) {
            return MethodWrapType.KillTaint;
        }
        return MethodWrapType.NotRegistered;
    }

    private MethodWrapType getInterfaceWrapType(String subSig, SootClass ifc) {
        if (ifc.isPhantom()) {
            return this.getMethodWrapTypeDirect(ifc.getName(), subSig);
        }
        assert (ifc.isInterface()) : "Class " + ifc.getName() + " is not an interface, though returned by getInterfaces().";
        for (SootClass pifc : Scene.v().getActiveHierarchy().getSuperinterfacesOfIncluding(ifc)) {
            MethodWrapType wt = this.getMethodWrapTypeDirect(pifc.getName(), subSig);
            if (wt == MethodWrapType.NotRegistered) continue;
            return wt;
        }
        return MethodWrapType.NotRegistered;
    }

    @Override
    public boolean isExclusiveInternal(Stmt stmt, AccessPath taintedPath) {
        InstanceInvokeExpr iiExpr;
        SootMethod method = stmt.getInvokeExpr().getMethod();
        if (this.hasWrappedMethodsForClass(method.getDeclaringClass(), true, true, false)) {
            return true;
        }
        if (this.aggressiveMode && stmt.getInvokeExpr() instanceof InstanceInvokeExpr && (iiExpr = (InstanceInvokeExpr)stmt.getInvokeExpr()).getBase().equals(taintedPath.getPlainValue())) {
            return true;
        }
        MethodWrapType wrapType = this.methodWrapCache.getUnchecked(method);
        return wrapType != MethodWrapType.NotRegistered;
    }

    public void setAggressiveMode(boolean aggressiveMode) {
        this.aggressiveMode = aggressiveMode;
    }

    public boolean getAggressiveMode() {
        return this.aggressiveMode;
    }

    public void setAlwaysModelEqualsHashCode(boolean alwaysModelEqualsHashCode) {
        this.alwaysModelEqualsHashCode = alwaysModelEqualsHashCode;
    }

    public boolean getAlwaysModelEqualsHashCode() {
        return this.alwaysModelEqualsHashCode;
    }

    public void addIncludePrefix(String prefix) {
        this.includeList.add(prefix);
    }

    public void addMethodForWrapping(String className, String subSignature) {
        Set<String> methods = this.classList.get(className);
        if (methods == null) {
            methods = new HashSet<String>();
            this.classList.put(className, methods);
        }
        methods.add(subSignature);
    }

    public EasyTaintWrapper clone() {
        return new EasyTaintWrapper(this);
    }

    @Override
    public boolean supportsCallee(SootMethod method) {
        if (this.aggressiveMode) {
            return true;
        }
        String subSig = method.getSubSignature();
        if (this.alwaysModelEqualsHashCode && (subSig.equals("boolean equals(java.lang.Object)") || subSig.equals("int hashCode()"))) {
            return true;
        }
        for (String supportedClass : this.includeList) {
            if (!method.getDeclaringClass().getName().startsWith(supportedClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsCallee(Stmt callSite) {
        MethodWrapType wrapType;
        if (!callSite.containsInvokeExpr()) {
            return false;
        }
        SootMethod method = callSite.getInvokeExpr().getMethod();
        if (!this.supportsCallee(method)) {
            return false;
        }
        if (!this.aggressiveMode && (wrapType = this.methodWrapCache.getUnchecked(method)) != MethodWrapType.CreateTaint) {
            return false;
        }
        if (callSite.getInvokeExpr() instanceof InstanceInvokeExpr) {
            return true;
        }
        for (Value val : callSite.getInvokeExpr().getArgs()) {
            if (val instanceof Constant) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        return null;
    }

    private static enum MethodWrapType {
        CreateTaint,
        KillTaint,
        Exclude,
        NotRegistered;

    }
}

