/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util;

import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.jimple.infoflow.data.AccessPath;

public class SystemClassHandler {
    public static boolean isClassInSystemPackage(String className) {
        return className.startsWith("android.") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.google.") || className.startsWith("org.omg.") || className.startsWith("org.w3c.dom.");
    }

    public static boolean isClassInSystemPackage(Type type) {
        if (type instanceof RefType) {
            return SystemClassHandler.isClassInSystemPackage(((RefType)type).getSootClass().getName());
        }
        return false;
    }

    public static boolean isTaintVisible(AccessPath taintedPath, SootMethod method) {
        if (taintedPath == null) {
            return true;
        }
        if (!taintedPath.isInstanceFieldRef()) {
            return true;
        }
        if (!SystemClassHandler.isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return true;
        }
        for (SootField fld : taintedPath.getFields()) {
            if (!SystemClassHandler.isClassInSystemPackage(fld.getType())) {
                return false;
            }
            if (SystemClassHandler.isClassInSystemPackage(fld.getDeclaringClass().getType())) continue;
            return false;
        }
        return true;
    }
}

