/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.builder;

import java.util.ArrayList;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.internal.SparkNativeHelper;
import soot.jimple.spark.pag.MethodPAG;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.pointer.DumbPointerAnalysis;
import soot.jimple.toolkits.pointer.util.NativeMethodDriver;
import soot.options.SparkOptions;
import soot.util.queue.QueueReader;

public class ContextInsensitiveBuilder {
    private PAG pag;
    private CallGraphBuilder cgb;
    private OnFlyCallGraph ofcg;
    private ReachableMethods reachables;
    int classes = 0;
    int totalMethods = 0;
    int analyzedMethods = 0;
    int stmts = 0;

    public void preJimplify() {
        boolean change = true;
        while (change) {
            change = false;
            for (SootClass c : new ArrayList<SootClass>(Scene.v().getClasses())) {
                for (SootMethod m : c.getMethods()) {
                    if (!m.isConcrete() || m.isNative() || m.isPhantom() || m.hasActiveBody()) continue;
                    change = true;
                    m.retrieveActiveBody();
                }
            }
        }
    }

    public PAG setup(SparkOptions opts) {
        PAG pAG = this.pag = opts.geom_pta() ? new GeomPointsTo(opts) : new PAG(opts);
        if (opts.simulate_natives()) {
            this.pag.nativeMethodDriver = new NativeMethodDriver(new SparkNativeHelper(this.pag));
        }
        if (opts.on_fly_cg() && !opts.vta()) {
            this.ofcg = new OnFlyCallGraph(this.pag, opts.apponly());
            this.pag.setOnFlyCallGraph(this.ofcg);
        } else {
            this.cgb = new CallGraphBuilder(DumbPointerAnalysis.v());
        }
        return this.pag;
    }

    public void build() {
        QueueReader<Edge> callEdges;
        if (this.ofcg != null) {
            callEdges = this.ofcg.callGraph().listener();
            this.ofcg.build();
            this.reachables = this.ofcg.reachableMethods();
            this.reachables.update();
        } else {
            callEdges = this.cgb.getCallGraph().listener();
            this.cgb.build();
            this.reachables = this.cgb.reachables();
        }
        for (SootClass c : Scene.v().getClasses()) {
            this.handleClass(c);
        }
        while (callEdges.hasNext()) {
            Edge e = callEdges.next();
            if (!e.getTgt().method().getDeclaringClass().isConcrete()) continue;
            if (e.tgt().isConcrete() || e.tgt().isNative()) {
                MethodPAG.v(this.pag, e.tgt()).addToPAG(null);
            }
            this.pag.addCallTarget(e);
        }
        if (this.pag.getOpts().verbose()) {
            G.v().out.println("Total methods: " + this.totalMethods);
            G.v().out.println("Initially reachable methods: " + this.analyzedMethods);
            G.v().out.println("Classes with at least one reachable method: " + this.classes);
        }
    }

    protected void handleClass(SootClass c) {
        boolean incedClasses = false;
        if (c.isConcrete()) {
            for (SootMethod m : c.getMethods()) {
                if (!m.isConcrete() && !m.isNative()) continue;
                ++this.totalMethods;
                if (!this.reachables.contains(m)) continue;
                MethodPAG mpag = MethodPAG.v(this.pag, m);
                mpag.build();
                mpag.addToPAG(null);
                ++this.analyzedMethods;
                if (incedClasses) continue;
                incedClasses = true;
                ++this.classes;
            }
        }
    }
}

