/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.Set;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.ValNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;

public final class PropMerge
extends Propagator {
    protected final Set<Node> varNodeWorkList = new TreeSet<Node>();
    protected PAG pag;

    public PropMerge(PAG pag) {
        this.pag = pag;
    }

    @Override
    public final void propagate() {
        new TopoSorter(this.pag, false).sort();
        for (AllocNode object : this.pag.allocSources()) {
            this.handleAllocNode(object);
        }
        boolean verbose = this.pag.getOpts().verbose();
        do {
            ValNode src;
            if (verbose) {
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            int iter = 0;
            while (!this.varNodeWorkList.isEmpty()) {
                VarNode src2 = (VarNode)this.varNodeWorkList.iterator().next();
                this.varNodeWorkList.remove(src2);
                this.handleVarNode(src2);
                if (!verbose || ++iter < 1000) continue;
                iter = 0;
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            if (verbose) {
                G.v().out.println("Now handling field references");
            }
            for (VarNode varNode : this.pag.storeSources()) {
                Node[] storeTargets;
                src = varNode;
                for (Node element0 : storeTargets = this.pag.storeLookup((VarNode)src)) {
                    FieldRefNode fr = (FieldRefNode)element0;
                    fr.makeP2Set().addAll(src.getP2Set(), null);
                }
            }
            for (ValNode valNode : this.pag.loadSources()) {
                src = (FieldRefNode)valNode;
                if (src != ((FieldRefNode)src).getReplacement()) {
                    throw new RuntimeException("shouldn't happen");
                }
                Node[] targets = this.pag.loadLookup((FieldRefNode)src);
                for (Node element0 : targets) {
                    VarNode target = (VarNode)element0;
                    if (!target.makeP2Set().addAll(src.getP2Set(), null)) continue;
                    this.varNodeWorkList.add(target);
                }
            }
        } while (!this.varNodeWorkList.isEmpty());
    }

    protected final boolean handleAllocNode(AllocNode src) {
        Node[] targets;
        boolean ret = false;
        for (Node element : targets = this.pag.allocLookup(src)) {
            if (!element.makeP2Set().add(src)) continue;
            this.varNodeWorkList.add(element);
            ret = true;
        }
        return ret;
    }

    protected final boolean handleVarNode(VarNode src) {
        Node[] simpleTargets;
        boolean ret = false;
        if (src.getReplacement() != src) {
            return ret;
        }
        PointsToSetInternal newP2Set = src.getP2Set();
        if (newP2Set.isEmpty()) {
            return false;
        }
        for (Node element : simpleTargets = this.pag.simpleLookup(src)) {
            if (!element.makeP2Set().addAll(newP2Set, null)) continue;
            this.varNodeWorkList.add(element);
            ret = true;
        }
        Node[] storeTargets = this.pag.storeLookup(src);
        for (Node element : storeTargets) {
            FieldRefNode fr = (FieldRefNode)element;
            if (!fr.makeP2Set().addAll(newP2Set, null)) continue;
            ret = true;
        }
        for (final FieldRefNode fr : src.getAllFieldRefs()) {
            final SparkField field = fr.getField();
            ret = newP2Set.forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropMerge.this.pag.makeAllocDotField((AllocNode)n, field);
                    Node nDotFNode = nDotF.getReplacement();
                    if (nDotFNode != fr) {
                        fr.mergeWith(nDotFNode);
                        this.returnValue = true;
                    }
                }
            }) | ret;
        }
        return ret;
    }
}

