/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.ide.icfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.SynchronizedBy;
import heros.solver.IDESolver;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.FastHierarchy;
import soot.Local;
import soot.Main;
import soot.NullType;
import soot.PackManager;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.Transform;
import soot.Unit;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.toolkits.ide.icfg.AbstractJimpleBasedICFG;
import soot.jimple.toolkits.pointer.LocalMustNotAliasAnalysis;
import soot.options.Options;

public class OnTheFlyJimpleBasedICFG
extends AbstractJimpleBasedICFG {
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<Body, LocalMustNotAliasAnalysis> bodyToLMNAA = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<Body, LocalMustNotAliasAnalysis>(){

        @Override
        public LocalMustNotAliasAnalysis load(Body body) throws Exception {
            return new LocalMustNotAliasAnalysis(OnTheFlyJimpleBasedICFG.this.getOrCreateUnitGraph(body), body);
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<Unit, Set<SootMethod>> unitToCallees = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<Unit, Set<SootMethod>>(){

        @Override
        public Set<SootMethod> load(Unit u) throws Exception {
            Stmt stmt = (Stmt)u;
            InvokeExpr ie = stmt.getInvokeExpr();
            FastHierarchy fastHierarchy = Scene.v().getFastHierarchy();
            if (ie instanceof InstanceInvokeExpr) {
                SootClass baseTypeClass;
                if (ie instanceof SpecialInvokeExpr) {
                    return Collections.singleton(ie.getMethod());
                }
                InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                Local base = (Local)iie.getBase();
                RefType concreteType = OnTheFlyJimpleBasedICFG.this.bodyToLMNAA.getUnchecked((Body)OnTheFlyJimpleBasedICFG.this.unitToOwner.get(u)).concreteType(base, stmt);
                if (concreteType != null) {
                    SootMethod singleTargetMethod = fastHierarchy.resolveConcreteDispatch(concreteType.getSootClass(), iie.getMethod());
                    return Collections.singleton(singleTargetMethod);
                }
                if (base.getType() instanceof RefType) {
                    RefType refType = (RefType)base.getType();
                    baseTypeClass = refType.getSootClass();
                } else if (base.getType() instanceof ArrayType) {
                    baseTypeClass = Scene.v().getSootClass("java.lang.Object");
                } else {
                    if (base.getType() instanceof NullType) {
                        return Collections.emptySet();
                    }
                    throw new InternalError("Unexpected base type:" + base.getType());
                }
                return fastHierarchy.resolveAbstractDispatch(baseTypeClass, iie.getMethod());
            }
            return Collections.singleton(ie.getMethod());
        }
    });
    @SynchronizedBy(value="explicit lock on data structure")
    protected Map<SootMethod, Set<Unit>> methodToCallers = new HashMap<SootMethod, Set<Unit>>();

    public OnTheFlyJimpleBasedICFG(SootMethod ... entryPoints) {
        this(Arrays.asList(entryPoints));
    }

    public OnTheFlyJimpleBasedICFG(Collection<SootMethod> entryPoints) {
        for (SootMethod m : entryPoints) {
            this.initForMethod(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Body initForMethod(SootMethod m) {
        assert (Scene.v().hasFastHierarchy());
        Body b = null;
        if (m.isConcrete()) {
            SootClass declaringClass = m.getDeclaringClass();
            this.ensureClassHasBodies(declaringClass);
            Object object = Scene.v();
            synchronized (object) {
                b = m.retrieveActiveBody();
            }
            if (b != null) {
                Unit u;
                object = b.getUnits().iterator();
                while (object.hasNext() && this.unitToOwner.put(u = (Unit)object.next(), b) == null) {
                }
            }
        }
        assert (Scene.v().hasFastHierarchy());
        return b;
    }

    private synchronized void ensureClassHasBodies(SootClass cl) {
        assert (Scene.v().hasFastHierarchy());
        if (cl.resolvingLevel() < 3) {
            Scene.v().forceResolve(cl.getName(), 3);
            Scene.v().getOrMakeFastHierarchy();
        }
        assert (Scene.v().hasFastHierarchy());
    }

    @Override
    public Set<SootMethod> getCalleesOfCallAt(Unit u) {
        Set<SootMethod> targets = this.unitToCallees.getUnchecked(u);
        for (SootMethod m : targets) {
            this.addCallerForMethod(u, m);
            this.initForMethod(m);
        }
        return targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallerForMethod(Unit callSite, SootMethod target) {
        Map<SootMethod, Set<Unit>> map = this.methodToCallers;
        synchronized (map) {
            Set<Unit> callers = this.methodToCallers.get(target);
            if (callers == null) {
                callers = new HashSet<Unit>();
                this.methodToCallers.put(target, callers);
            }
            callers.add(callSite);
        }
    }

    @Override
    public Set<Unit> getCallersOf(SootMethod m) {
        Set<Unit> callers = this.methodToCallers.get(m);
        return callers == null ? Collections.emptySet() : callers;
    }

    public static void loadAllClassesOnClassPathToSignatures() {
        for (String path : SourceLocator.explodeClassPath(Scene.v().getSootClassPath())) {
            for (String cl : SourceLocator.v().getClassesUnder(path)) {
                Scene.v().forceResolve(cl, 2);
            }
        }
    }

    public static void main(String[] args) {
        PackManager.v().getPack("wjtp").add(new Transform("wjtp.onflyicfg", new SceneTransformer(){

            @Override
            protected void internalTransform(String phaseName, Map<String, String> options) {
                if (Scene.v().hasCallGraph()) {
                    throw new RuntimeException("call graph present!");
                }
                OnTheFlyJimpleBasedICFG.loadAllClassesOnClassPathToSignatures();
                SootMethod mainMethod = Scene.v().getMainMethod();
                OnTheFlyJimpleBasedICFG icfg = new OnTheFlyJimpleBasedICFG(mainMethod);
                LinkedHashSet<SootMethod> worklist = new LinkedHashSet<SootMethod>();
                HashSet<SootMethod> visited = new HashSet<SootMethod>();
                worklist.add(mainMethod);
                int monomorphic = 0;
                int polymorphic = 0;
                while (!worklist.isEmpty()) {
                    Iterator iter = worklist.iterator();
                    SootMethod currMethod = (SootMethod)iter.next();
                    iter.remove();
                    visited.add(currMethod);
                    System.err.println(currMethod);
                    Body body = currMethod.getActiveBody();
                    if (body == null) continue;
                    for (Unit u : body.getUnits()) {
                        Stmt s = (Stmt)u;
                        if (!s.containsInvokeExpr()) continue;
                        Set<SootMethod> calleesOfCallAt = icfg.getCalleesOfCallAt(s);
                        if (s.getInvokeExpr() instanceof VirtualInvokeExpr || s.getInvokeExpr() instanceof InterfaceInvokeExpr) {
                            if (calleesOfCallAt.size() <= 1) {
                                ++monomorphic;
                            } else {
                                ++polymorphic;
                            }
                            System.err.println("mono: " + monomorphic + "   poly: " + polymorphic);
                        }
                        for (SootMethod callee : calleesOfCallAt) {
                            if (visited.contains(callee)) continue;
                            System.err.println(callee);
                        }
                    }
                }
            }
        }));
        Options.v().set_on_the_fly(true);
        Main.main(args);
    }
}

