/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.ErroneousType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PhaseOptions;
import soot.ShortType;
import soot.Singletons;
import soot.StmtAddressType;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.util.Chain;

public class LocalNameStandardizer
extends BodyTransformer {
    public LocalNameStandardizer(Singletons.Global g) {
    }

    public static LocalNameStandardizer v() {
        return G.v().soot_jimple_toolkits_scalar_LocalNameStandardizer();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        boolean onlyStackName = PhaseOptions.getBoolean(options, "only-stack-locals");
        boolean sortLocals = PhaseOptions.getBoolean(options, "sort-locals");
        int objectCount = 0;
        int intCount = 0;
        int longCount = 0;
        int floatCount = 0;
        int doubleCount = 0;
        int addressCount = 0;
        int errorCount = 0;
        int nullCount = 0;
        if (sortLocals) {
            Chain<Local> locals = body.getLocals();
            final List<ValueBox> defs = body.getDefBoxes();
            ArrayList<Local> sortedLocals = new ArrayList<Local>(locals);
            Collections.sort(sortedLocals, new Comparator<Local>(){
                private Map<Local, Integer> firstOccuranceCache = new HashMap<Local, Integer>();

                @Override
                public int compare(Local arg0, Local arg1) {
                    int ret = arg0.getType().toString().compareTo(arg1.getType().toString());
                    if (ret == 0) {
                        ret = Integer.compare(this.getFirstOccurance(arg0), this.getFirstOccurance(arg1));
                    }
                    return ret;
                }

                private int getFirstOccurance(Local l) {
                    Integer cur = this.firstOccuranceCache.get(l);
                    if (cur != null) {
                        return cur;
                    }
                    int count = 0;
                    int first = -1;
                    for (ValueBox vb : defs) {
                        Value v = vb.getValue();
                        if (v instanceof Local && v.equals(l)) {
                            first = count;
                            break;
                        }
                        ++count;
                    }
                    this.firstOccuranceCache.put(l, first);
                    return first;
                }
            });
            locals.clear();
            locals.addAll(sortedLocals);
        }
        for (Local l : body.getLocals()) {
            String prefix = "";
            if (l.getName().startsWith("$")) {
                prefix = "$";
            } else if (onlyStackName) continue;
            if (l.getType().equals(BooleanType.v())) {
                l.setName(prefix + "z" + intCount++);
                continue;
            }
            if (l.getType().equals(ByteType.v())) {
                l.setName(prefix + "b" + longCount++);
                continue;
            }
            if (l.getType().equals(ShortType.v())) {
                l.setName(prefix + "s" + longCount++);
                continue;
            }
            if (l.getType().equals(CharType.v())) {
                l.setName(prefix + "c" + longCount++);
                continue;
            }
            if (l.getType().equals(IntType.v())) {
                l.setName(prefix + "i" + longCount++);
                continue;
            }
            if (l.getType().equals(LongType.v())) {
                l.setName(prefix + "l" + longCount++);
                continue;
            }
            if (l.getType().equals(DoubleType.v())) {
                l.setName(prefix + "d" + doubleCount++);
                continue;
            }
            if (l.getType().equals(FloatType.v())) {
                l.setName(prefix + "f" + floatCount++);
                continue;
            }
            if (l.getType().equals(StmtAddressType.v())) {
                l.setName(prefix + "a" + addressCount++);
                continue;
            }
            if (l.getType().equals(ErroneousType.v()) || l.getType().equals(UnknownType.v())) {
                l.setName(prefix + "e" + errorCount++);
                continue;
            }
            if (l.getType().equals(NullType.v())) {
                l.setName(prefix + "n" + nullCount++);
                continue;
            }
            l.setName(prefix + "r" + objectCount++);
        }
    }
}

