/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.HashSet;
import java.util.List;
import soot.Body;
import soot.Trap;
import soot.Unit;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum JimpleTrapValidator implements BodyValidator
{
    INSTANCE;


    public static JimpleTrapValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        HashSet<Unit> caughtUnits = new HashSet<Unit>();
        for (Trap trap : body.getTraps()) {
            caughtUnits.add(trap.getHandlerUnit());
            if (!(trap.getHandlerUnit() instanceof IdentityStmt)) {
                exception.add(new ValidationException(trap, "Trap handler does start with caught exception reference"));
                continue;
            }
            IdentityStmt is = (IdentityStmt)trap.getHandlerUnit();
            if (is.getRightOp() instanceof CaughtExceptionRef) continue;
            exception.add(new ValidationException(trap, "Trap handler does start with caught exception reference"));
        }
        for (Unit u : body.getUnits()) {
            IdentityStmt id;
            if (!(u instanceof IdentityStmt) || !((id = (IdentityStmt)u).getRightOp() instanceof CaughtExceptionRef) || caughtUnits.contains(id)) continue;
            exception.add(new ValidationException(id, "Could not find a corresponding trap using this statement as handler", "Body of method " + body.getMethod().getSignature() + " contains a caught exception reference, but not a corresponding trap using this statement as handler"));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

