/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum NewValidator implements BodyValidator
{
    INSTANCE;


    public static NewValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        BriefUnitGraph g = new BriefUnitGraph(body);
        for (Unit u : body.getUnits()) {
            AssignStmt assign;
            if (!(u instanceof AssignStmt) || !((assign = (AssignStmt)u).getRightOp() instanceof NewExpr)) continue;
            if (!(assign.getLeftOp().getType() instanceof RefType)) {
                exception.add(new ValidationException(u, "A new-expression must be used on reference type locals", "Body of method " + body.getMethod().getSignature() + " contains a new-expression, which is assigned to a non-reference local"));
                return;
            }
            LinkedHashSet<Local> locals = new LinkedHashSet<Local>();
            locals.add((Local)assign.getLeftOp());
            this.checkForInitializerOnPath(g, (Local)assign.getLeftOp(), assign, exception);
        }
    }

    private boolean checkForInitializerOnPath(UnitGraph g, Local initLocal, Unit stmt, List<ValidationException> exception) {
        String errorMsg = "There is a path to " + stmt + " where <init> does not get called in between.";
        ArrayList<Unit> workList = new ArrayList<Unit>();
        HashSet<Stmt> doneSet = new HashSet<Stmt>();
        workList.add(stmt);
        HashSet<Local> aliasingLocals = new HashSet<Local>();
        aliasingLocals.add(initLocal);
        while (!workList.isEmpty()) {
            List<Unit> successors;
            InvokeExpr expr;
            Stmt curStmt = (Stmt)workList.remove(0);
            if (!doneSet.add(curStmt)) continue;
            if (curStmt.containsInvokeExpr() && (expr = curStmt.getInvokeExpr()).getMethod().isConstructor()) {
                if (!(expr instanceof SpecialInvokeExpr)) {
                    exception.add(new ValidationException(curStmt, "<init> method calls may only be used with specialinvoke."));
                    return true;
                }
                if (!(curStmt instanceof InvokeStmt)) {
                    exception.add(new ValidationException(curStmt, "<init> methods may only be called with invoke statements."));
                    return true;
                }
                SpecialInvokeExpr invoke = (SpecialInvokeExpr)expr;
                if (aliasingLocals.contains(invoke.getBase())) continue;
            }
            boolean creatingAlias = false;
            if (curStmt instanceof AssignStmt) {
                Local originalLocal;
                AssignStmt assignCheck = (AssignStmt)curStmt;
                if (aliasingLocals.contains(assignCheck.getRightOp()) && assignCheck.getLeftOp() instanceof Local) {
                    aliasingLocals.add((Local)assignCheck.getLeftOp());
                    creatingAlias = true;
                }
                if ((originalLocal = (Local)aliasingLocals.iterator().next()).equals(assignCheck.getLeftOp())) continue;
                aliasingLocals.remove(assignCheck.getLeftOp());
            }
            if (!creatingAlias) {
                for (ValueBox box : curStmt.getUseBoxes()) {
                    Value used = box.getValue();
                    if (!aliasingLocals.contains(used)) continue;
                    exception.add(new ValidationException(stmt, errorMsg));
                    return false;
                }
            }
            if ((successors = g.getSuccsOf(curStmt)).isEmpty()) {
                exception.add(new ValidationException(stmt, errorMsg));
                return false;
            }
            workList.addAll(successors);
        }
        return true;
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

