/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import soot.Local;
import soot.PatchingChain;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.shimple.PiExpr;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleFactory;
import soot.shimple.internal.SHashMultiMap;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.DominanceFrontier;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;
import soot.toolkits.graph.ReversibleGraph;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class PiNodeManager {
    protected ShimpleBody body;
    protected ShimpleFactory sf;
    protected DominatorTree<Block> dt;
    protected DominanceFrontier<Block> df;
    protected ReversibleGraph<Block> cfg;
    protected boolean trimmed;
    protected MultiMap<Local, Block> varToBlocks;

    public PiNodeManager(ShimpleBody body, boolean trimmed, ShimpleFactory sf) {
        this.body = body;
        this.trimmed = trimmed;
        this.sf = sf;
    }

    public void update() {
        this.cfg = this.sf.getReverseBlockGraph();
        this.dt = this.sf.getReverseDominatorTree();
        this.df = this.sf.getReverseDominanceFrontier();
    }

    public boolean insertTrivialPiNodes() {
        this.update();
        boolean change = false;
        SHashMultiMap<Local, Block> localsToUsePoints = new SHashMultiMap<Local, Block>();
        this.varToBlocks = new HashMultiMap<Local, Block>();
        for (Block block : this.cfg) {
            for (Unit unit : block) {
                List<ValueBox> useBoxes = unit.getUseBoxes();
                Iterator<ValueBox> useBoxesIt = useBoxes.iterator();
                while (useBoxesIt.hasNext()) {
                    Value use = useBoxesIt.next().getValue();
                    if (!(use instanceof Local)) continue;
                    localsToUsePoints.put((Local)use, block);
                }
                if (!Shimple.isPiNode(unit)) continue;
                this.varToBlocks.put(Shimple.getLhsLocal(unit), block);
            }
        }
        int[] workFlags = new int[this.cfg.size()];
        int[] hasAlreadyFlags = new int[this.cfg.size()];
        int iterCount = 0;
        Stack<Block> workList = new Stack<Block>();
        for (Local local : localsToUsePoints.keySet()) {
            ++iterCount;
            for (Block block : localsToUsePoints.get(local)) {
                workFlags[block.getIndexInMethod()] = iterCount;
                workList.push(block);
            }
            while (!workList.empty()) {
                Block block = (Block)workList.pop();
                DominatorNode<Block> node = this.dt.getDode(block);
                for (DominatorNode<Block> frontierNode : this.df.getDominanceFrontierOf(node)) {
                    Block frontierBlock = frontierNode.getGode();
                    int fBIndex = frontierBlock.getIndexInMethod();
                    if (hasAlreadyFlags[fBIndex] >= iterCount) continue;
                    this.insertPiNodes(local, frontierBlock);
                    change = true;
                    hasAlreadyFlags[fBIndex] = iterCount;
                    if (workFlags[fBIndex] >= iterCount) continue;
                    workFlags[fBIndex] = iterCount;
                    workList.push(frontierBlock);
                }
            }
        }
        if (change) {
            this.sf.clearCache();
        }
        return change;
    }

    public void insertPiNodes(Local local, Block frontierBlock) {
        Unit u;
        block7: {
            if (this.varToBlocks.get(local).contains(frontierBlock.getSuccs().get(0))) {
                return;
            }
            u = frontierBlock.getTail();
            if (this.trimmed) {
                for (ValueBox vb : u.getUseBoxes()) {
                    if (!vb.getValue().equals(local)) continue;
                    break block7;
                }
                return;
            }
        }
        if (u instanceof IfStmt) {
            this.piHandleIfStmt(local, (IfStmt)u);
        } else if (u instanceof LookupSwitchStmt || u instanceof TableSwitchStmt) {
            this.piHandleSwitchStmt(local, u);
        } else {
            throw new RuntimeException("Assertion failed: Unhandled stmt: " + u);
        }
    }

    public void piHandleIfStmt(Local local, IfStmt u) {
        Stmt target = u.getTarget();
        PiExpr pit = Shimple.v().newPiExpr(local, u, Boolean.TRUE);
        PiExpr pif = Shimple.v().newPiExpr(local, u, Boolean.FALSE);
        AssignStmt addt = Jimple.v().newAssignStmt(local, pit);
        AssignStmt addf = Jimple.v().newAssignStmt(local, pif);
        PatchingChain<Unit> units = this.body.getUnits();
        units.insertAfter(addf, (Unit)u);
        Unit predOfTarget = null;
        try {
            predOfTarget = units.getPredOf(target);
        }
        catch (NoSuchElementException e) {
            predOfTarget = null;
        }
        if (predOfTarget != null && predOfTarget.fallsThrough()) {
            GotoStmt gotoStmt = Jimple.v().newGotoStmt(target);
            units.insertAfter(gotoStmt, predOfTarget);
        }
        units.getNonPatchingChain().insertBefore(addt, (Unit)target);
        u.setTarget(addt);
    }

    public void piHandleSwitchStmt(Local local, Unit u) {
        ArrayList<UnitBox> targetBoxes = new ArrayList<UnitBox>();
        ArrayList<Object> targetKeys = new ArrayList<Object>();
        if (u instanceof LookupSwitchStmt) {
            LookupSwitchStmt lss = (LookupSwitchStmt)u;
            targetBoxes.add(lss.getDefaultTargetBox());
            targetKeys.add("default");
            for (int i = 0; i < lss.getTargetCount(); ++i) {
                targetBoxes.add(lss.getTargetBox(i));
            }
            targetKeys.addAll(lss.getLookupValues());
        } else if (u instanceof TableSwitchStmt) {
            int i;
            TableSwitchStmt tss = (TableSwitchStmt)u;
            int low = tss.getLowIndex();
            int hi = tss.getHighIndex();
            targetBoxes.add(tss.getDefaultTargetBox());
            targetKeys.add("default");
            for (i = 0; i <= hi - low; ++i) {
                targetBoxes.add(tss.getTargetBox(i));
            }
            for (i = low; i <= hi; ++i) {
                targetKeys.add(new Integer(i));
            }
        } else {
            throw new RuntimeException("Assertion failed.");
        }
        for (int count = 0; count < targetBoxes.size(); ++count) {
            UnitBox targetBox = (UnitBox)targetBoxes.get(count);
            Unit target = targetBox.getUnit();
            Object targetKey = targetKeys.get(count);
            PiExpr pi1 = Shimple.v().newPiExpr(local, u, targetKey);
            AssignStmt add1 = Jimple.v().newAssignStmt(local, pi1);
            PatchingChain<Unit> units = this.body.getUnits();
            Unit predOfTarget = null;
            try {
                predOfTarget = units.getPredOf(target);
            }
            catch (NoSuchElementException e) {
                predOfTarget = null;
            }
            if (predOfTarget != null && predOfTarget.fallsThrough()) {
                GotoStmt gotoStmt = Jimple.v().newGotoStmt(target);
                units.insertAfter(gotoStmt, predOfTarget);
            }
            units.getNonPatchingChain().insertBefore(add1, target);
            targetBox.setUnit(add1);
        }
    }

    public void eliminatePiNodes(boolean smart) {
        if (smart) {
            HashMap<Local, Value> newToOld = new HashMap<Local, Value>();
            ArrayList<ValueBox> boxes = new ArrayList<ValueBox>();
            Iterator<Unit> unitsIt = this.body.getUnits().iterator();
            while (unitsIt.hasNext()) {
                Unit u = unitsIt.next();
                PiExpr pe = Shimple.getPiExpr(u);
                if (pe != null) {
                    newToOld.put(Shimple.getLhsLocal(u), pe.getValue());
                    unitsIt.remove();
                    continue;
                }
                boxes.addAll(u.getUseBoxes());
            }
            for (ValueBox box : boxes) {
                Value value = box.getValue();
                Value old = (Value)newToOld.get(value);
                if (old == null) continue;
                box.setValue(old);
            }
            DeadAssignmentEliminator.v().transform(this.body);
            CopyPropagator.v().transform(this.body);
            DeadAssignmentEliminator.v().transform(this.body);
        } else {
            for (Unit u : this.body.getUnits()) {
                PiExpr pe = Shimple.getPiExpr(u);
                if (pe == null) continue;
                ((AssignStmt)u).setRightOp(pe.getValue());
            }
        }
    }

    public static List<ValueBox> getUseBoxesFromBlock(Block block) {
        Iterator<Unit> unitsIt = block.iterator();
        ArrayList<ValueBox> useBoxesList = new ArrayList<ValueBox>();
        while (unitsIt.hasNext()) {
            useBoxesList.addAll(unitsIt.next().getUseBoxes());
        }
        return useBoxesList;
    }
}

