/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.LinkedList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Unit;
import soot.baf.BafBody;
import soot.tagkit.CodeAttribute;
import soot.tagkit.Tag;

public abstract class TagAggregator
extends BodyTransformer {
    public abstract boolean wantTag(Tag var1);

    public abstract void considerTag(Tag var1, Unit var2, LinkedList<Tag> var3, LinkedList<Unit> var4);

    public abstract String aggregatedName();

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        BafBody body = (BafBody)b;
        LinkedList<Tag> tags = new LinkedList<Tag>();
        LinkedList<Unit> units = new LinkedList<Unit>();
        for (Unit unit : body.getUnits()) {
            for (Tag tag : unit.getTags()) {
                if (!this.wantTag(tag)) continue;
                this.considerTag(tag, unit, tags, units);
            }
        }
        if (units.size() > 0) {
            b.addTag(new CodeAttribute(this.aggregatedName(), new LinkedList<Unit>(units), new LinkedList<Tag>(tags)));
        }
        this.fini();
    }

    public void fini() {
    }
}

