/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.builder.DexBuilder;
import soot.jimple.AbstractConstantSwitch;
import soot.jimple.ClassConstant;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;
import soot.toDex.StmtVisitor;
import soot.toDex.instructions.Insn;
import soot.toDex.instructions.Insn11n;
import soot.toDex.instructions.Insn21c;
import soot.toDex.instructions.Insn21s;
import soot.toDex.instructions.Insn31i;
import soot.toDex.instructions.Insn51l;

class ConstantVisitor
extends AbstractConstantSwitch {
    private final DexBuilder dexFile;
    private StmtVisitor stmtV;
    private Register destinationReg;
    private Stmt origStmt;

    public ConstantVisitor(DexBuilder dexFile, StmtVisitor stmtV) {
        this.stmtV = stmtV;
        this.dexFile = dexFile;
    }

    public void setDestination(Register destinationReg) {
        this.destinationReg = destinationReg;
    }

    public void setOrigStmt(Stmt stmt) {
        this.origStmt = stmt;
    }

    @Override
    public void defaultCase(Object o) {
        throw new Error("unknown Object (" + o.getClass() + ") as Constant: " + o);
    }

    @Override
    public void caseStringConstant(StringConstant s) {
        BuilderStringReference ref = this.dexFile.internStringReference(s.value);
        this.stmtV.addInsn(new Insn21c(Opcode.CONST_STRING, this.destinationReg, ref), this.origStmt);
    }

    @Override
    public void caseClassConstant(ClassConstant c) {
        boolean classIsArray = c.value.startsWith("[");
        String className = classIsArray ? c.value : SootToDexUtils.getDexClassName(c.value);
        BuilderTypeReference referencedClass = this.dexFile.internTypeReference(className);
        this.stmtV.addInsn(new Insn21c(Opcode.CONST_CLASS, this.destinationReg, referencedClass), this.origStmt);
    }

    @Override
    public void caseLongConstant(LongConstant l) {
        long constant = l.value;
        this.stmtV.addInsn(this.buildConstWideInsn(constant), this.origStmt);
    }

    private Insn buildConstWideInsn(long literal) {
        if (SootToDexUtils.fitsSigned16(literal)) {
            return new Insn21s(Opcode.CONST_WIDE_16, this.destinationReg, (short)literal);
        }
        if (SootToDexUtils.fitsSigned32(literal)) {
            return new Insn31i(Opcode.CONST_WIDE_32, this.destinationReg, (int)literal);
        }
        return new Insn51l(Opcode.CONST_WIDE, this.destinationReg, literal);
    }

    @Override
    public void caseDoubleConstant(DoubleConstant d) {
        long longBits = Double.doubleToLongBits(d.value);
        this.stmtV.addInsn(this.buildConstWideInsn(longBits), this.origStmt);
    }

    @Override
    public void caseFloatConstant(FloatConstant f) {
        int intBits = Float.floatToIntBits(f.value);
        this.stmtV.addInsn(this.buildConstInsn(intBits), this.origStmt);
    }

    private Insn buildConstInsn(int literal) {
        if (SootToDexUtils.fitsSigned4(literal)) {
            return new Insn11n(Opcode.CONST_4, this.destinationReg, (byte)literal);
        }
        if (SootToDexUtils.fitsSigned16(literal)) {
            return new Insn21s(Opcode.CONST_16, this.destinationReg, (short)literal);
        }
        return new Insn31i(Opcode.CONST, this.destinationReg, literal);
    }

    @Override
    public void caseIntConstant(IntConstant i) {
        this.stmtV.addInsn(this.buildConstInsn(i.value), this.origStmt);
    }

    @Override
    public void caseNullConstant(NullConstant v) {
        this.stmtV.addInsn(this.buildConstInsn(0), this.origStmt);
    }
}

