/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.DexBuilder;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.ConcreteRef;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StmtSwitch;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.toDex.ConstantVisitor;
import soot.toDex.DexArrayInitDetector;
import soot.toDex.DexPrinter;
import soot.toDex.ExprVisitor;
import soot.toDex.LabelAssigner;
import soot.toDex.LocalRegisterAssignmentInformation;
import soot.toDex.Register;
import soot.toDex.RegisterAllocator;
import soot.toDex.RegisterAssigner;
import soot.toDex.SootToDexUtils;
import soot.toDex.instructions.AbstractPayload;
import soot.toDex.instructions.AddressInsn;
import soot.toDex.instructions.ArrayDataPayload;
import soot.toDex.instructions.Insn;
import soot.toDex.instructions.Insn10t;
import soot.toDex.instructions.Insn10x;
import soot.toDex.instructions.Insn11x;
import soot.toDex.instructions.Insn12x;
import soot.toDex.instructions.Insn21c;
import soot.toDex.instructions.Insn22c;
import soot.toDex.instructions.Insn22x;
import soot.toDex.instructions.Insn23x;
import soot.toDex.instructions.Insn31t;
import soot.toDex.instructions.Insn32x;
import soot.toDex.instructions.InsnWithOffset;
import soot.toDex.instructions.PackedSwitchPayload;
import soot.toDex.instructions.SparseSwitchPayload;
import soot.toDex.instructions.SwitchPayload;

class StmtVisitor
implements StmtSwitch {
    private static final Map<Opcode, Opcode> oppositeIfs = new HashMap<Opcode, Opcode>();
    private final SootMethod belongingMethod;
    private final DexBuilder belongingFile;
    private final DexArrayInitDetector arrayInitDetector;
    private ConstantVisitor constantV;
    private RegisterAllocator regAlloc;
    private ExprVisitor exprV;
    private String lastReturnTypeDescriptor;
    private List<Insn> insns;
    private List<AbstractPayload> payloads;
    private Map<Insn, Stmt> insnStmtMap = new HashMap<Insn, Stmt>();
    private Map<Instruction, LocalRegisterAssignmentInformation> instructionRegisterMap = new IdentityHashMap<Instruction, LocalRegisterAssignmentInformation>();
    private Map<Instruction, Insn> instructionInsnMap = new IdentityHashMap<Instruction, Insn>();
    private Map<Insn, LocalRegisterAssignmentInformation> insnRegisterMap = new IdentityHashMap<Insn, LocalRegisterAssignmentInformation>();
    private Map<Instruction, AbstractPayload> instructionPayloadMap = new IdentityHashMap<Instruction, AbstractPayload>();
    private List<LocalRegisterAssignmentInformation> parameterInstructionsList = new ArrayList<LocalRegisterAssignmentInformation>();
    private Map<Constant, Register> monitorRegs = new HashMap<Constant, Register>();

    public StmtVisitor(SootMethod belongingMethod, DexBuilder belongingFile, DexArrayInitDetector arrayInitDetector) {
        this.belongingMethod = belongingMethod;
        this.belongingFile = belongingFile;
        this.arrayInitDetector = arrayInitDetector;
        this.constantV = new ConstantVisitor(belongingFile, this);
        this.regAlloc = new RegisterAllocator();
        this.exprV = new ExprVisitor(this, this.constantV, this.regAlloc, belongingFile);
        this.insns = new ArrayList<Insn>();
        this.payloads = new ArrayList<AbstractPayload>();
    }

    protected void setLastReturnTypeDescriptor(String typeDescriptor) {
        this.lastReturnTypeDescriptor = typeDescriptor;
    }

    protected DexBuilder getBelongingFile() {
        return this.belongingFile;
    }

    protected SootClass getBelongingClass() {
        return this.belongingMethod.getDeclaringClass();
    }

    public Stmt getStmtForInstruction(Instruction instruction) {
        Insn insn = this.instructionInsnMap.get(instruction);
        if (insn == null) {
            return null;
        }
        return this.insnStmtMap.get(insn);
    }

    public Insn getInsnForInstruction(Instruction instruction) {
        return this.instructionInsnMap.get(instruction);
    }

    public Map<Instruction, LocalRegisterAssignmentInformation> getInstructionRegisterMap() {
        return this.instructionRegisterMap;
    }

    public List<LocalRegisterAssignmentInformation> getParameterInstructionsList() {
        return this.parameterInstructionsList;
    }

    public Map<Instruction, AbstractPayload> getInstructionPayloadMap() {
        return this.instructionPayloadMap;
    }

    protected void addInsn(Insn insn, Stmt s) {
        int highestIndex = this.insns.size();
        this.addInsn(highestIndex, insn);
        if (s != null && this.insnStmtMap.put(insn, s) != null) {
            throw new RuntimeException("Duplicate instruction");
        }
    }

    private void addInsn(int positionInList, Insn insn) {
        this.insns.add(positionInList, insn);
    }

    protected void beginNewStmt(Stmt s) {
        this.regAlloc.resetImmediateConstantsPool();
        this.addInsn(new AddressInsn(s), null);
    }

    public void finalizeInstructions() {
        this.addPayloads();
        this.finishRegs();
        this.reduceInstructions();
    }

    private void reduceInstructions() {
        for (int i = 0; i < this.insns.size() - 1; ++i) {
            Stmt origStmt;
            Insn curInsn = this.insns.get(i);
            if (curInsn instanceof AddressInsn || !this.isReducableMoveInstruction(curInsn.getOpcode().name)) continue;
            Insn nextInsn = null;
            int nextIndex = -1;
            for (int j = i + 1; j < this.insns.size(); ++j) {
                Insn candidate = this.insns.get(j);
                if (candidate instanceof AddressInsn) continue;
                nextInsn = candidate;
                nextIndex = j;
                break;
            }
            if (nextInsn == null || !this.isReducableMoveInstruction(nextInsn.getOpcode().name) || nextIndex == this.insns.size() - 1) continue;
            Register firstTarget = curInsn.getRegs().get(0);
            Register firstSource = curInsn.getRegs().get(1);
            Register secondTarget = nextInsn.getRegs().get(0);
            Register secondSource = nextInsn.getRegs().get(1);
            if (!firstTarget.equals(secondSource) || !secondTarget.equals(firstSource) || (origStmt = this.insnStmtMap.get(nextInsn)) != null && this.isJumpTarget(origStmt)) continue;
            Insn nextStmt = this.insns.get(nextIndex + 1);
            this.insns.remove(nextIndex);
            if (origStmt == null) continue;
            this.insnStmtMap.remove(nextInsn);
            this.insnStmtMap.put(nextStmt, origStmt);
        }
    }

    private boolean isReducableMoveInstruction(String name) {
        return name.startsWith("move/") || name.startsWith("move-object/") || name.startsWith("move-wide/");
    }

    private boolean isJumpTarget(Stmt target) {
        for (Insn insn : this.insns) {
            if (!(insn instanceof InsnWithOffset) || ((InsnWithOffset)insn).getTarget() != target) continue;
            return true;
        }
        return false;
    }

    private void addPayloads() {
        for (AbstractPayload payload : this.payloads) {
            this.addInsn(new AddressInsn(payload), null);
            this.addInsn(payload, null);
        }
    }

    public List<BuilderInstruction> getRealInsns(LabelAssigner labelAssigner) {
        ArrayList<BuilderInstruction> finalInsns = new ArrayList<BuilderInstruction>();
        for (Insn i : this.insns) {
            if (i instanceof AddressInsn) continue;
            BuilderInstruction realInsn = i.getRealInsn(labelAssigner);
            finalInsns.add(realInsn);
            if (this.insnStmtMap.containsKey(i)) {
                this.instructionInsnMap.put(realInsn, i);
            }
            if (this.insnRegisterMap.containsKey(i)) {
                this.instructionRegisterMap.put(realInsn, this.insnRegisterMap.get(i));
            }
            if (!(i instanceof AbstractPayload)) continue;
            this.instructionPayloadMap.put(realInsn, (AbstractPayload)i);
        }
        return finalInsns;
    }

    public void fakeNewInsn(Stmt s, Insn insn, Instruction instruction) {
        this.insnStmtMap.put(insn, s);
        this.instructionInsnMap.put(instruction, insn);
    }

    private void finishRegs() {
        RegisterAssigner regAssigner = new RegisterAssigner(this.regAlloc);
        this.insns = regAssigner.finishRegs(this.insns, this.insnStmtMap, this.insnRegisterMap, this.parameterInstructionsList);
    }

    protected int getRegisterCount() {
        return this.regAlloc.getRegCount();
    }

    @Override
    public void defaultCase(Object o) {
        throw new Error("unknown Object (" + o.getClass() + ") as Stmt: " + o);
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
        this.addInsn(new Insn10x(Opcode.NOP), stmt);
    }

    @Override
    public void caseRetStmt(RetStmt stmt) {
        throw new Error("ret statements are deprecated!");
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        this.addInsn(this.buildMonitorInsn(stmt, Opcode.MONITOR_ENTER), stmt);
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        this.addInsn(this.buildMonitorInsn(stmt, Opcode.MONITOR_EXIT), stmt);
    }

    private Insn buildMonitorInsn(MonitorStmt stmt, Opcode opc) {
        Value lockValue = stmt.getOp();
        this.constantV.setOrigStmt(stmt);
        Register lockReg = null;
        if (lockValue instanceof Constant && (lockReg = this.monitorRegs.get(lockValue)) != null) {
            lockReg = lockReg.clone();
        }
        if (lockReg == null) {
            lockReg = this.regAlloc.asImmediate(lockValue, this.constantV);
            this.regAlloc.lockRegister(lockReg);
            if (lockValue instanceof Constant) {
                this.monitorRegs.put((Constant)lockValue, lockReg);
                this.regAlloc.lockRegister(lockReg);
            }
        }
        return new Insn11x(opc, lockReg);
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
        Value exception = stmt.getOp();
        this.constantV.setOrigStmt(stmt);
        Register exceptionReg = this.regAlloc.asImmediate(exception, this.constantV);
        this.addInsn(new Insn11x(Opcode.THROW, exceptionReg), stmt);
    }

    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        Insn insn;
        List<Value> arrayValues = this.arrayInitDetector.getValuesForArrayInit(stmt);
        if (arrayValues != null && (insn = this.buildArrayFillInsn((ArrayRef)stmt.getLeftOp(), arrayValues)) != null) {
            this.addInsn(insn, stmt);
            return;
        }
        if (this.arrayInitDetector.getIgnoreUnits().contains(stmt)) {
            return;
        }
        this.constantV.setOrigStmt(stmt);
        this.exprV.setOrigStmt(stmt);
        Value lhs = stmt.getLeftOp();
        if (lhs instanceof ConcreteRef) {
            Value source = stmt.getRightOp();
            this.addInsn(this.buildPutInsn((ConcreteRef)lhs, source), stmt);
            return;
        }
        if (!(lhs instanceof Local)) {
            throw new Error("left-hand side of AssignStmt is not a Local: " + lhs.getClass());
        }
        Local lhsLocal = (Local)lhs;
        Register lhsReg = this.regAlloc.asLocal(lhsLocal);
        Value rhs = stmt.getRightOp();
        if (rhs instanceof Local) {
            String rhsName;
            String lhsName = ((Local)lhs).getName();
            if (lhsName.equals(rhsName = ((Local)rhs).getName())) {
                return;
            }
            Register sourceReg = this.regAlloc.asLocal((Local)rhs);
            this.addInsn(StmtVisitor.buildMoveInsn(lhsReg, sourceReg), stmt);
        } else if (rhs instanceof Constant) {
            this.constantV.setDestination(lhsReg);
            rhs.apply(this.constantV);
        } else if (rhs instanceof ConcreteRef) {
            this.addInsn(this.buildGetInsn((ConcreteRef)rhs, lhsReg), stmt);
        } else {
            this.exprV.setDestinationReg(lhsReg);
            rhs.apply(this.exprV);
            if (rhs instanceof InvokeExpr) {
                Insn moveResultInsn = this.buildMoveResultInsn(lhsReg);
                int invokeInsnIndex = this.insns.indexOf(this.getLastInvokeInsn());
                this.addInsn(invokeInsnIndex + 1, moveResultInsn);
            }
        }
        this.insnRegisterMap.put(this.insns.get(this.insns.size() - 1), LocalRegisterAssignmentInformation.v(lhsReg, lhsLocal));
    }

    private Insn buildGetInsn(ConcreteRef sourceRef, Register destinationReg) {
        if (sourceRef instanceof StaticFieldRef) {
            return this.buildStaticFieldGetInsn(destinationReg, (StaticFieldRef)sourceRef);
        }
        if (sourceRef instanceof InstanceFieldRef) {
            return this.buildInstanceFieldGetInsn(destinationReg, (InstanceFieldRef)sourceRef);
        }
        if (sourceRef instanceof ArrayRef) {
            return this.buildArrayGetInsn(destinationReg, (ArrayRef)sourceRef);
        }
        throw new RuntimeException("unsupported type of ConcreteRef: " + sourceRef.getClass());
    }

    private Insn buildPutInsn(ConcreteRef destRef, Value source) {
        if (destRef instanceof StaticFieldRef) {
            return this.buildStaticFieldPutInsn((StaticFieldRef)destRef, source);
        }
        if (destRef instanceof InstanceFieldRef) {
            return this.buildInstanceFieldPutInsn((InstanceFieldRef)destRef, source);
        }
        if (destRef instanceof ArrayRef) {
            return this.buildArrayPutInsn((ArrayRef)destRef, source);
        }
        throw new RuntimeException("unsupported type of ConcreteRef: " + destRef.getClass());
    }

    protected static Insn buildMoveInsn(Register destinationReg, Register sourceReg) {
        String opcType = sourceReg.isObject() ? "MOVE_OBJECT" : (sourceReg.isWide() ? "MOVE_WIDE" : "MOVE");
        if (!destinationReg.fitsShort()) {
            Opcode opc = Opcode.valueOf(opcType + "_16");
            return new Insn32x(opc, destinationReg, sourceReg);
        }
        if (!destinationReg.fitsByte() || !sourceReg.fitsByte()) {
            Opcode opc = Opcode.valueOf(opcType + "_FROM16");
            return new Insn22x(opc, destinationReg, sourceReg);
        }
        Opcode opc = Opcode.valueOf(opcType);
        return new Insn12x(opc, destinationReg, sourceReg);
    }

    private Insn buildStaticFieldPutInsn(StaticFieldRef destRef, Value source) {
        SootField destSootField = destRef.getField();
        Register sourceReg = this.regAlloc.asImmediate(source, this.constantV);
        BuilderFieldReference destField = DexPrinter.toFieldReference(destSootField, this.belongingFile);
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("sput", destField.getType());
        return new Insn21c(opc, sourceReg, destField);
    }

    private Insn buildInstanceFieldPutInsn(InstanceFieldRef destRef, Value source) {
        SootField destSootField = destRef.getField();
        BuilderFieldReference destField = DexPrinter.toFieldReference(destSootField, this.belongingFile);
        Local instance = (Local)destRef.getBase();
        Register instanceReg = this.regAlloc.asLocal(instance);
        Register sourceReg = this.regAlloc.asImmediate(source, this.constantV);
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("iput", destField.getType());
        return new Insn22c(opc, sourceReg, instanceReg, destField);
    }

    private Insn buildArrayPutInsn(ArrayRef destRef, Value source) {
        Local array = (Local)destRef.getBase();
        Register arrayReg = this.regAlloc.asLocal(array);
        Value index = destRef.getIndex();
        Register indexReg = this.regAlloc.asImmediate(index, this.constantV);
        Register sourceReg = this.regAlloc.asImmediate(source, this.constantV);
        String arrayTypeDescriptor = SootToDexUtils.getArrayTypeDescriptor((ArrayType)array.getType());
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("aput", arrayTypeDescriptor);
        return new Insn23x(opc, sourceReg, arrayReg, indexReg);
    }

    private Insn buildArrayFillInsn(ArrayRef destRef, List<Value> values) {
        Local array = (Local)destRef.getBase();
        Register arrayReg = this.regAlloc.asLocal(array);
        int elementSize = 0;
        ArrayList<Number> numbers = new ArrayList<Number>(values.size());
        for (Value val : values) {
            if (val instanceof IntConstant) {
                elementSize = Math.max(elementSize, 4);
                numbers.add(((IntConstant)val).value);
                continue;
            }
            if (val instanceof LongConstant) {
                elementSize = Math.max(elementSize, 8);
                numbers.add(((LongConstant)val).value);
                continue;
            }
            if (val instanceof FloatConstant) {
                elementSize = Math.max(elementSize, 4);
                numbers.add(Float.valueOf(((FloatConstant)val).value));
                continue;
            }
            if (val instanceof DoubleConstant) {
                elementSize = Math.max(elementSize, 8);
                numbers.add(((DoubleConstant)val).value);
                continue;
            }
            return null;
        }
        if (destRef.getType() instanceof BooleanType) {
            elementSize = 1;
        } else if (destRef.getType() instanceof ByteType) {
            elementSize = 1;
        } else if (destRef.getType() instanceof CharType) {
            elementSize = 2;
        } else if (destRef.getType() instanceof ShortType) {
            elementSize = 2;
        } else if (destRef.getType() instanceof IntType) {
            elementSize = 4;
        } else if (destRef.getType() instanceof FloatType) {
            elementSize = 4;
        } else if (destRef.getType() instanceof LongType) {
            elementSize = 8;
        } else if (destRef.getType() instanceof DoubleType) {
            elementSize = 8;
        }
        ArrayDataPayload payload = new ArrayDataPayload(elementSize, numbers);
        this.payloads.add(payload);
        Insn31t insn = new Insn31t(Opcode.FILL_ARRAY_DATA, arrayReg);
        insn.setPayload(payload);
        return insn;
    }

    private Insn buildStaticFieldGetInsn(Register destinationReg, StaticFieldRef sourceRef) {
        SootField sourceSootField = sourceRef.getField();
        BuilderFieldReference sourceField = DexPrinter.toFieldReference(sourceSootField, this.belongingFile);
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("sget", sourceField.getType());
        return new Insn21c(opc, destinationReg, sourceField);
    }

    private Insn buildInstanceFieldGetInsn(Register destinationReg, InstanceFieldRef sourceRef) {
        Local instance = (Local)sourceRef.getBase();
        Register instanceReg = this.regAlloc.asLocal(instance);
        SootField sourceSootField = sourceRef.getField();
        BuilderFieldReference sourceField = DexPrinter.toFieldReference(sourceSootField, this.belongingFile);
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("iget", sourceField.getType());
        return new Insn22c(opc, destinationReg, instanceReg, sourceField);
    }

    private Insn buildArrayGetInsn(Register destinationReg, ArrayRef sourceRef) {
        Value index = sourceRef.getIndex();
        Register indexReg = this.regAlloc.asImmediate(index, this.constantV);
        Local array = (Local)sourceRef.getBase();
        Register arrayReg = this.regAlloc.asLocal(array);
        String arrayTypeDescriptor = SootToDexUtils.getArrayTypeDescriptor((ArrayType)array.getType());
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("aget", arrayTypeDescriptor);
        return new Insn23x(opc, destinationReg, arrayReg, indexReg);
    }

    private Opcode getPutGetOpcodeWithTypeSuffix(String prefix, String fieldType) {
        prefix = prefix.toUpperCase();
        if (fieldType.equals("Z")) {
            return Opcode.valueOf(prefix + "_BOOLEAN");
        }
        if (fieldType.equals("I") || fieldType.equals("F")) {
            return Opcode.valueOf(prefix);
        }
        if (fieldType.equals("B")) {
            return Opcode.valueOf(prefix + "_BYTE");
        }
        if (fieldType.equals("C")) {
            return Opcode.valueOf(prefix + "_CHAR");
        }
        if (fieldType.equals("S")) {
            return Opcode.valueOf(prefix + "_SHORT");
        }
        if (SootToDexUtils.isWide(fieldType)) {
            return Opcode.valueOf(prefix + "_WIDE");
        }
        if (SootToDexUtils.isObject(fieldType)) {
            return Opcode.valueOf(prefix + "_OBJECT");
        }
        throw new RuntimeException("unsupported field type for *put*/*get* opcode: " + fieldType);
    }

    private Insn getLastInvokeInsn() {
        ListIterator<Insn> listIterator = this.insns.listIterator(this.insns.size());
        while (listIterator.hasPrevious()) {
            Insn inst = listIterator.previous();
            if (!inst.getOpcode().name.startsWith("invoke-")) continue;
            return inst;
        }
        throw new Error("tried to get last invoke-* instruction, but there was none!");
    }

    private Insn buildMoveResultInsn(Register destinationReg) {
        Opcode opc = SootToDexUtils.isObject(this.lastReturnTypeDescriptor) ? Opcode.MOVE_RESULT_OBJECT : (SootToDexUtils.isWide(this.lastReturnTypeDescriptor) ? Opcode.MOVE_RESULT_WIDE : Opcode.MOVE_RESULT);
        return new Insn11x(opc, destinationReg);
    }

    @Override
    public void caseInvokeStmt(InvokeStmt stmt) {
        this.exprV.setOrigStmt(stmt);
        stmt.getInvokeExpr().apply(this.exprV);
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
        this.addInsn(new Insn10x(Opcode.RETURN_VOID), stmt);
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        Value returnValue = stmt.getOp();
        this.constantV.setOrigStmt(stmt);
        Register returnReg = this.regAlloc.asImmediate(returnValue, this.constantV);
        Type retType = returnValue.getType();
        Opcode opc = SootToDexUtils.isObject(retType) ? Opcode.RETURN_OBJECT : (SootToDexUtils.isWide(retType) ? Opcode.RETURN_WIDE : Opcode.RETURN);
        this.addInsn(new Insn11x(opc, returnReg), stmt);
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
        Local lhs = (Local)stmt.getLeftOp();
        Value rhs = stmt.getRightOp();
        if (rhs instanceof CaughtExceptionRef) {
            Register localReg = this.regAlloc.asLocal(lhs);
            this.addInsn(new Insn11x(Opcode.MOVE_EXCEPTION, localReg), stmt);
            this.insnRegisterMap.put(this.insns.get(this.insns.size() - 1), LocalRegisterAssignmentInformation.v(localReg, lhs));
        } else if (rhs instanceof ThisRef || rhs instanceof ParameterRef) {
            Local localForThis = lhs;
            this.regAlloc.asParameter(this.belongingMethod, localForThis);
            this.parameterInstructionsList.add(LocalRegisterAssignmentInformation.v(this.regAlloc.asLocal(localForThis).clone(), localForThis));
        } else {
            throw new Error("unknown Value as right-hand side of IdentityStmt: " + rhs);
        }
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
        Stmt target = (Stmt)stmt.getTarget();
        this.addInsn(this.buildGotoInsn(target), stmt);
    }

    private Insn buildGotoInsn(Stmt target) {
        if (target == null) {
            throw new RuntimeException("Cannot jump to a NULL target");
        }
        Insn10t insn = new Insn10t(Opcode.GOTO);
        insn.setTarget(target);
        return insn;
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        this.exprV.setOrigStmt(stmt);
        this.constantV.setOrigStmt(stmt);
        List<IntConstant> keyValues = stmt.getLookupValues();
        int[] keys = new int[keyValues.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = keyValues.get((int)i).value;
        }
        List<Unit> targets = stmt.getTargets();
        SparseSwitchPayload payload = new SparseSwitchPayload(keys, targets);
        this.payloads.add(payload);
        Value key = stmt.getKey();
        Stmt defaultTarget = (Stmt)stmt.getDefaultTarget();
        if (defaultTarget == stmt) {
            throw new RuntimeException("Looping switch block detected");
        }
        this.addInsn(this.buildSwitchInsn(Opcode.SPARSE_SWITCH, key, defaultTarget, payload, stmt), stmt);
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        this.exprV.setOrigStmt(stmt);
        this.constantV.setOrigStmt(stmt);
        int firstKey = stmt.getLowIndex();
        List<Unit> targets = stmt.getTargets();
        PackedSwitchPayload payload = new PackedSwitchPayload(firstKey, targets);
        this.payloads.add(payload);
        Value key = stmt.getKey();
        Stmt defaultTarget = (Stmt)stmt.getDefaultTarget();
        this.addInsn(this.buildSwitchInsn(Opcode.PACKED_SWITCH, key, defaultTarget, payload, stmt), stmt);
    }

    private Insn buildSwitchInsn(Opcode opc, Value key, Stmt defaultTarget, SwitchPayload payload, Stmt stmt) {
        Register keyReg = this.regAlloc.asImmediate(key, this.constantV);
        Insn31t switchInsn = new Insn31t(opc, keyReg);
        switchInsn.setPayload(payload);
        payload.setSwitchInsn(switchInsn);
        this.addInsn(switchInsn, stmt);
        return this.buildGotoInsn(defaultTarget);
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        Stmt target = stmt.getTarget();
        this.exprV.setOrigStmt(stmt);
        this.exprV.setTargetForOffset(target);
        stmt.getCondition().apply(this.exprV);
    }

    public void preAllocateMonitorConsts(Set<ClassConstant> monitorConsts) {
        for (ClassConstant c : monitorConsts) {
            Register lhsReg = this.regAlloc.asImmediate(c, this.constantV);
            this.regAlloc.lockRegister(lhsReg);
            this.monitorRegs.put(c, lhsReg);
        }
    }

    static {
        oppositeIfs.put(Opcode.IF_EQ, Opcode.IF_NE);
        oppositeIfs.put(Opcode.IF_NE, Opcode.IF_EQ);
        oppositeIfs.put(Opcode.IF_EQZ, Opcode.IF_NEZ);
        oppositeIfs.put(Opcode.IF_NEZ, Opcode.IF_EQZ);
        oppositeIfs.put(Opcode.IF_GT, Opcode.IF_LE);
        oppositeIfs.put(Opcode.IF_LE, Opcode.IF_GT);
        oppositeIfs.put(Opcode.IF_GTZ, Opcode.IF_LEZ);
        oppositeIfs.put(Opcode.IF_LEZ, Opcode.IF_GTZ);
        oppositeIfs.put(Opcode.IF_GE, Opcode.IF_LT);
        oppositeIfs.put(Opcode.IF_LT, Opcode.IF_GE);
        oppositeIfs.put(Opcode.IF_GEZ, Opcode.IF_LTZ);
        oppositeIfs.put(Opcode.IF_LTZ, Opcode.IF_GEZ);
    }
}

