/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.CommandLineArguments;
import edu.psu.cse.siis.coal.FatalAnalysisException;
import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.PropagationTimers;
import edu.psu.cse.siis.coal.lang.ParseException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import soot.PackManager;

public abstract class Analysis<A extends CommandLineArguments> {
    public void performAnalysis(A commandLineArguments) {
        try {
            PropagationTimers.v().modelParsing.start();
            this.loadModel(commandLineArguments);
            PropagationTimers.v().modelParsing.end();
            PropagationTimers.v().misc.start();
            this.registerFieldTransformerFactories(commandLineArguments);
            this.registerArgumentValueAnalyses(commandLineArguments);
            this.registerMethodReturnValueAnalyses(commandLineArguments);
            this.setApplicationClasses(commandLineArguments);
            PropagationTimers.v().misc.end();
            this.initializeAnalysis(commandLineArguments);
            PropagationTimers.v().soot.start();
            PackManager.v().runPacks();
            PropagationTimers.v().soot.end();
            this.processResults(commandLineArguments);
            this.finalizeAnalysis(commandLineArguments);
        }
        catch (FatalAnalysisException e) {
            this.handleFatalAnalysisException(commandLineArguments, e);
        }
    }

    protected void loadModel(A commanLineArguments) throws FatalAnalysisException {
        block4: {
            try {
                if (((CommandLineArguments)commanLineArguments).getCompiledModel() != null) {
                    Model.loadModelFromCompiledFile(((CommandLineArguments)commanLineArguments).getCompiledModel());
                    break block4;
                }
                if (((CommandLineArguments)commanLineArguments).getModel() != null) {
                    Model.loadModel(((CommandLineArguments)commanLineArguments).getModel());
                    break block4;
                }
                throw new FatalAnalysisException("No model file or directory was specified");
            }
            catch (ParseException | IOException | ClassNotFoundException e) {
                throw new FatalAnalysisException("Could not load model", e);
            }
        }
    }

    protected abstract void registerFieldTransformerFactories(A var1) throws FatalAnalysisException;

    protected abstract void registerArgumentValueAnalyses(A var1) throws FatalAnalysisException;

    protected abstract void registerMethodReturnValueAnalyses(A var1) throws FatalAnalysisException;

    protected void setApplicationClasses(A commandLineArguments) throws FatalAnalysisException {
        AnalysisParameters.v().addAnalysisClasses(this.computeAnalysisClasses(((CommandLineArguments)commandLineArguments).getInput()));
        if (((CommandLineArguments)commandLineArguments).traverseModeled()) {
            AnalysisParameters.v().addAnalysisClasses(Model.v().getModeledTypes());
        }
    }

    protected abstract void initializeAnalysis(A var1) throws FatalAnalysisException;

    protected abstract void processResults(A var1) throws FatalAnalysisException;

    protected abstract void finalizeAnalysis(A var1) throws FatalAnalysisException;

    protected abstract void handleFatalAnalysisException(A var1, FatalAnalysisException var2);

    protected Set<String> computeAnalysisClasses(String dirOrJar) throws FatalAnalysisException {
        try {
            File file = new File(dirOrJar);
            if (file.isDirectory()) {
                String directoryString = file.getCanonicalPath();
                int basePos = directoryString.length() + 1;
                return this.computeAnalysisClassesInDir(file, basePos);
            }
            return this.computeAnalysisClassesInJar(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new FatalAnalysisException(e);
        }
    }

    private Set<String> computeAnalysisClassesInDir(File directory, int basePos) throws IOException {
        File[] nestedFilesAndDirs = directory.listFiles();
        HashSet<String> result = new HashSet<String>();
        for (File nestedFile : nestedFilesAndDirs) {
            if (nestedFile.isDirectory()) {
                result.addAll(this.computeAnalysisClassesInDir(nestedFile, basePos));
                continue;
            }
            String canonicalPath = nestedFile.getCanonicalPath();
            if (!canonicalPath.endsWith(".class")) continue;
            result.add(canonicalPath.substring(basePos, canonicalPath.length() - 6).replace('/', '.'));
        }
        return result;
    }

    private Set<String> computeAnalysisClassesInJar(File file) throws IOException {
        HashSet<String> result = new HashSet<String>();
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class")) continue;
            String name = entryName.substring(0, entryName.length() - 6).replace('/', '.');
            result.add(name);
        }
        jarFile.close();
        return result;
    }
}

