/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.toolkits.ide.icfg.JimpleBasedInterproceduralCFG;

public class AnalysisParameters {
    private static AnalysisParameters instance = new AnalysisParameters();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<String> analysisClasses;
    private boolean iterative = true;
    private JimpleBasedInterproceduralCFG icfg;
    private boolean inferNonModeledTypes = true;
    private boolean useShimple = false;
    private int threadCount;

    public void addAnalysisClasses(Collection<String> classes) {
        if (this.analysisClasses == null) {
            this.analysisClasses = new HashSet<String>();
        }
        this.analysisClasses.addAll(classes);
    }

    public boolean isAnalysisClass(String clazz) {
        if (this.analysisClasses == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("No analysis classes set. To change this, use Analysis.v().addAnalysisClasses()");
            }
            return false;
        }
        return this.analysisClasses.contains(clazz);
    }

    public Set<String> getAnalysisClasses() {
        return this.analysisClasses;
    }

    public boolean isIterative() {
        return this.iterative;
    }

    public void setIcfg(JimpleBasedInterproceduralCFG icfg) {
        this.icfg = icfg;
    }

    public JimpleBasedInterproceduralCFG getIcfg() {
        return this.icfg;
    }

    public void setInferNonModeledTypes(boolean inferNonModeledTypes) {
        this.inferNonModeledTypes = inferNonModeledTypes;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean inferNonModeledTypes() {
        return this.inferNonModeledTypes;
    }

    public boolean useShimple() {
        return this.useShimple;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public static AnalysisParameters v() {
        return instance;
    }

    private AnalysisParameters() {
    }
}

