/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.FunctionFactoryUtils;
import edu.psu.cse.siis.coal.Model;
import heros.FlowFunction;
import heros.flowfunc.KillAll;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;

public class CallFlowFunctionFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FlowFunction<Value> getCallFlowFunction(Unit src, final SootMethod dest, Value zeroValue) {
        InvokeExpr ie;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Call: " + src);
        }
        String declaringClass = dest.getDeclaringClass().getName();
        if (!AnalysisParameters.v().isAnalysisClass(declaringClass)) {
            return KillAll.v();
        }
        Stmt stmt = (Stmt)src;
        boolean containsInvokeExpr = stmt.containsInvokeExpr();
        InvokeExpr invokeExpr = ie = containsInvokeExpr ? stmt.getInvokeExpr() : null;
        if (containsInvokeExpr && (Model.v().getArgumentsForGenMethod(ie) != null || Model.v().getArgumentsForCopyConstructor(ie.getMethodRef()) != null)) {
            return KillAll.v();
        }
        return new FlowFunction<Value>(){

            @Override
            public Set<Value> computeTargets(Value source) {
                if (CallFlowFunctionFactory.this.logger.isDebugEnabled()) {
                    CallFlowFunctionFactory.this.logger.debug("Source: " + source);
                }
                if (dest.getName().equals("<clinit>")) {
                    if (source instanceof FieldRef) {
                        return Collections.singleton(source);
                    }
                    return Collections.emptySet();
                }
                ArrayList<Local> paramLocals = new ArrayList<Local>();
                for (int i = 0; i < dest.getParameterCount(); ++i) {
                    paramLocals.add(dest.getActiveBody().getParameterLocal(i));
                }
                int argIndex = FunctionFactoryUtils.shouldPropagateSource(source, ie.getArgs());
                if (argIndex != -1) {
                    if (CallFlowFunctionFactory.this.logger.isDebugEnabled()) {
                        CallFlowFunctionFactory.this.logger.debug("Returning " + paramLocals.get(argIndex));
                    }
                    return Collections.singleton(paramLocals.get(argIndex));
                }
                if (source instanceof StaticFieldRef) {
                    return Collections.singleton(source);
                }
                if (source instanceof InstanceFieldRef && FunctionFactoryUtils.shouldPropagateInstanceField((InstanceFieldRef)source, ie)) {
                    return Collections.singleton(source);
                }
                if (CallFlowFunctionFactory.this.logger.isDebugEnabled()) {
                    CallFlowFunctionFactory.this.logger.debug("Returning empty set");
                }
                return Collections.emptySet();
            }
        };
    }
}

