/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.FunctionFactoryUtils;
import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.transformers.PropagationTransformerFactory;
import edu.psu.cse.siis.coal.values.BasePropagationValue;
import heros.EdgeFunction;
import heros.edgefunc.EdgeIdentity;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public class CallToReturnEdgeFunctionFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public EdgeFunction<BasePropagationValue> getCallToReturnEdgeFunction(Unit callSite, Value callNode, Unit returnSite, Value returnSideNode, PointsToAnalysis pointsToAnalysis) {
        InvokeExpr invokeExpr;
        Stmt callStmt = (Stmt)callSite;
        InvokeExpr invokeExpr2 = invokeExpr = callStmt.containsInvokeExpr() ? callStmt.getInvokeExpr() : null;
        if (invokeExpr != null) {
            Argument[] arguments = Model.v().getArgumentsForMethod(invokeExpr);
            if (arguments != null) {
                PointsToSet callNodePointsToSet;
                InstanceInvokeExpr instanceInvokeExpr;
                Value base;
                PointsToSet basePointsToSet;
                if (invokeExpr instanceof InstanceInvokeExpr && (basePointsToSet = pointsToAnalysis.reachingObjects((Local)(base = (instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr).getBase()))).hasNonEmptyIntersection(callNodePointsToSet = FunctionFactoryUtils.getPointsToSetForValue(callNode))) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Call node " + callNode);
                        this.logger.debug("Stmt " + callSite);
                        this.logger.debug("Returning " + PropagationTransformerFactory.makeTransformer(callSite, arguments, !callNode.equals(base)));
                    }
                    return PropagationTransformerFactory.makeTransformer(callSite, arguments, !callNode.equals(base));
                }
            } else {
                arguments = Model.v().getArgumentsForGenMethod(invokeExpr);
                if (arguments != null) {
                    DefinitionStmt definitionStmt;
                    Value leftValue;
                    if (callStmt instanceof DefinitionStmt && (leftValue = (definitionStmt = (DefinitionStmt)callStmt).getLeftOp()).equals(returnSideNode)) {
                        return PropagationTransformerFactory.makeTransformer(callSite, arguments, false);
                    }
                } else if (callSite instanceof DefinitionStmt) {
                    DefinitionStmt definitionStmt = (DefinitionStmt)callSite;
                    arguments = Model.v().getArgumentsForCopyConstructor(invokeExpr.getMethodRef().getSignature());
                    if (arguments != null && callNode.equals(invokeExpr.getArg(arguments[0].getArgnum()[0])) && returnSideNode.equals(definitionStmt.getLeftOp())) {
                        Argument[] extraArguments = Arrays.copyOfRange(arguments, 1, arguments.length);
                        return PropagationTransformerFactory.makeTransformer(callSite, extraArguments, false);
                    }
                }
            }
        }
        return EdgeIdentity.v();
    }
}

