/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.arguments.Argument;
import heros.FlowFunction;
import heros.flowfunc.Identity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.toolkits.ide.icfg.JimpleBasedInterproceduralCFG;

public class CallToReturnFlowFunctionFactory {
    private final Logger logger = LoggerFactory.getLogger(CallToReturnFlowFunctionFactory.class);

    public FlowFunction<Value> getCallToReturnFlowFunction(final Unit call, Unit returnSite, final Value zeroValue, JimpleBasedInterproceduralCFG icfg) {
        DefinitionStmt definitionStmt;
        Stmt stmt = (Stmt)call;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("C2R: " + stmt);
        }
        if (!stmt.containsInvokeExpr()) {
            return Identity.v();
        }
        final InvokeExpr invokeExpr = stmt.getInvokeExpr();
        SootMethodRef methodRef = invokeExpr.getMethodRef();
        if (call instanceof DefinitionStmt) {
            definitionStmt = (DefinitionStmt)call;
            if (Model.v().getArgumentsForGenMethod(invokeExpr) != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Detected gen modifier: " + call);
                }
                final Value leftValue = definitionStmt.getLeftOp();
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        if (CallToReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            CallToReturnFlowFunctionFactory.this.logger.debug("source: " + source);
                        }
                        if (source.equals(zeroValue)) {
                            if (CallToReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                                CallToReturnFlowFunctionFactory.this.logger.debug("Returning " + leftValue);
                            }
                            return Collections.singleton(leftValue);
                        }
                        if (!source.equals(leftValue)) {
                            if (CallToReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                                CallToReturnFlowFunctionFactory.this.logger.debug("Returning " + source);
                            }
                            return Collections.singleton(source);
                        }
                        if (CallToReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            CallToReturnFlowFunctionFactory.this.logger.debug("Returning empty set");
                        }
                        return Collections.emptySet();
                    }
                };
            }
            if (Model.v().getArgumentsForCopyMethod(invokeExpr) != null && invokeExpr instanceof InstanceInvokeExpr) {
                final Value leftValue = definitionStmt.getLeftOp();
                InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
                final Value base = instanceInvokeExpr.getBase();
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        HashSet<Value> result = new HashSet<Value>();
                        if (source.equals(base)) {
                            result.add(leftValue);
                        }
                        if (!source.equals(leftValue)) {
                            result.add(source);
                        }
                        return result;
                    }
                };
            }
            final Argument[] arguments = Model.v().getArgumentsForCopyConstructor(methodRef);
            if (arguments != null) {
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        if (CallToReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            CallToReturnFlowFunctionFactory.this.logger.debug("Copy constructor " + call);
                            CallToReturnFlowFunctionFactory.this.logger.debug("Source: " + source);
                        }
                        HashSet<Value> result = new HashSet<Value>();
                        Value argument = invokeExpr.getArg(arguments[0].getArgnum()[0]);
                        if (!source.equivTo(definitionStmt.getLeftOp())) {
                            result.add(source);
                        }
                        if (argument.equivTo(source)) {
                            result.add(definitionStmt.getLeftOp());
                        }
                        if (CallToReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            CallToReturnFlowFunctionFactory.this.logger.debug("Returning " + result);
                        }
                        return result;
                    }
                };
            }
        }
        if (!AnalysisParameters.v().isAnalysisClass(methodRef.declaringClass().getName())) {
            return Identity.v();
        }
        if (call instanceof InvokeStmt) {
            if (Model.v().getArgumentsForQuery((Stmt)call) != null || Model.v().getArgumentsForMethod(invokeExpr) != null) {
                return Identity.v();
            }
            final Argument[] copyConstructorArguments = Model.v().getArgumentsForCopyConstructor(invokeExpr.getMethodRef());
            if (copyConstructorArguments != null) {
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        if (CallToReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            CallToReturnFlowFunctionFactory.this.logger.debug("Copy constructor " + call);
                            CallToReturnFlowFunctionFactory.this.logger.debug("Source: " + source);
                        }
                        HashSet<Value> result = new HashSet<Value>();
                        InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
                        Value base = instanceInvokeExpr.getBase();
                        Value argument = instanceInvokeExpr.getArg(copyConstructorArguments[0].getArgnum()[0]);
                        if (!source.equivTo(base)) {
                            result.add(source);
                        }
                        if (argument.equivTo(source)) {
                            result.add(base);
                        }
                        if (CallToReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            CallToReturnFlowFunctionFactory.this.logger.debug("Returning " + result);
                        }
                        return result;
                    }
                };
            }
            if (icfg.getCalleesOfCallAt(call).size() == 0) {
                return Identity.v();
            }
            return new FlowFunction<Value>(){

                @Override
                public Set<Value> computeTargets(Value source) {
                    for (Value arg : invokeExpr.getArgs()) {
                        if (!arg.equivTo(source)) continue;
                        return Collections.emptySet();
                    }
                    return Collections.singleton(source);
                }
            };
        }
        if (call instanceof DefinitionStmt) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ctr def stmt: " + call);
            }
            definitionStmt = (DefinitionStmt)call;
            if (Model.v().getArgumentsForQuery(definitionStmt) != null || Model.v().getArgumentsForMethod(invokeExpr) != null) {
                if (methodRef.isStatic()) {
                    return Identity.v();
                }
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        Value leftOp = definitionStmt.getLeftOp();
                        HashSet<Value> res = new HashSet<Value>();
                        String typeString = leftOp.getType().toString();
                        if (!leftOp.equivTo(source) || !Model.v().isModeledType(typeString)) {
                            res.add(source);
                        }
                        SootMethod method = invokeExpr.getMethod();
                        if (invokeExpr instanceof VirtualInvokeExpr && method.isConcrete()) {
                            if (!method.hasActiveBody()) {
                                method.retrieveActiveBody();
                            }
                            for (Unit unit : method.getActiveBody().getUnits()) {
                                Value retLocal;
                                if (!(unit instanceof ReturnStmt) || !(retLocal = ((ReturnStmt)unit).getOp()).equivTo(invokeExpr.getMethod().getActiveBody().getThisLocal()) || !source.equivTo(((VirtualInvokeExpr)invokeExpr).getBase())) continue;
                                res.add(leftOp);
                            }
                        }
                        if (CallToReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            CallToReturnFlowFunctionFactory.this.logger.debug("Returning: " + res);
                        }
                        return res;
                    }
                };
            }
            if (icfg.getCalleesOfCallAt(call).size() == 0) {
                return Identity.v();
            }
            return new FlowFunction<Value>(){

                @Override
                public Set<Value> computeTargets(Value source) {
                    for (Value arg : invokeExpr.getArgs()) {
                        if (!arg.equivTo(source)) continue;
                        return Collections.emptySet();
                    }
                    Value left = definitionStmt.getLeftOp();
                    if (left.equivTo(source) || left.toString().equals(source.toString())) {
                        return Collections.emptySet();
                    }
                    return Collections.singleton(source);
                }
            };
        }
        return Identity.v();
    }
}

