/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.CommandLineArguments;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandLineParser<A extends CommandLineArguments> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public A parseCommandLine(String[] args, Class<A> clazz) {
        int threadCount;
        Options options = new Options();
        this.parseDefaultCommandLineArguments(options);
        this.parseAnalysisSpecificArguments(options);
        CommandLine commandLine = null;
        try {
            DefaultParser commandLineParser = new DefaultParser();
            commandLine = commandLineParser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelp(options);
            this.logger.error("Could not parse command line arguments", e);
            return null;
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = (CommandLineArguments)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.logger.error("Could not instantiate type " + clazz, e);
            return null;
        }
        commandLineArguments.setCommandLine(commandLine);
        commandLineArguments.setModel(commandLine.getOptionValue("model"));
        commandLineArguments.setCompiledModel(commandLine.getOptionValue("cmodel"));
        commandLineArguments.setInput(commandLine.getOptionValue("in"));
        commandLineArguments.setClasspath(String.format("%s:%s:", commandLine.getOptionValue("cp"), commandLineArguments.getInput()));
        commandLineArguments.setOutput(commandLine.getOptionValue("out"));
        commandLineArguments.setTraverseModeled(commandLine.hasOption("traversemodeled"));
        AnalysisParameters.v().setInferNonModeledTypes(!commandLine.hasOption("modeledtypesonly"));
        try {
            threadCount = commandLineArguments.hasOption("threadcount") ? ((Number)commandLineArguments.getParsedOptionValue("threadcount")).intValue() : Runtime.getRuntime().availableProcessors();
        }
        catch (ParseException exception) {
            this.logger.error("Could not parse thread count: " + commandLineArguments.getOptionValue("threadcount"), exception);
            return null;
        }
        AnalysisParameters.v().setThreadCount(threadCount);
        return (A)commandLineArguments;
    }

    protected abstract void parseAnalysisSpecificArguments(Options var1);

    protected abstract void printHelp(Options var1);

    private void parseDefaultCommandLineArguments(Options options) {
        OptionGroup modelGroup = new OptionGroup();
        modelGroup.addOption(Option.builder("model").desc("Path to the model directory.").hasArg().argName("model directory").build());
        modelGroup.addOption(Option.builder("cmodel").desc("Path to the compiled model.").hasArg().argName("compiled model").build());
        modelGroup.setRequired(false);
        options.addOptionGroup(modelGroup);
        options.addOption(Option.builder("cp").desc("The classpath for the analysis.").hasArg().argName("classpath").required().longOpt("classpath").build());
        options.addOption(Option.builder("in").desc("The input code for the analysis.").hasArg().argName("input").required().longOpt("input").build());
        options.addOption(Option.builder("out").desc("The output directory or file.").hasArg().argName("output").longOpt("output").build());
        options.addOption(Option.builder("traversemodeled").desc("Propagate through modeled classes.").hasArg(false).build());
        options.addOption("modeledtypesonly", false, "Only infer modeled types.");
        options.addOption(Option.builder("threadcount").desc("The maximum number of threads that should be used.").hasArg().argName("thread count").type(Number.class).build());
    }
}

