/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.Analysis;
import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.CommandLineArguments;
import edu.psu.cse.siis.coal.DefaultResultBuilder;
import edu.psu.cse.siis.coal.DefaultResultProcessor;
import edu.psu.cse.siis.coal.FatalAnalysisException;
import edu.psu.cse.siis.coal.PropagationSceneTransformer;
import edu.psu.cse.siis.coal.PropagationSceneTransformerFilePrinter;
import edu.psu.cse.siis.coal.SymbolFilter;
import edu.psu.cse.siis.coal.arguments.ArgumentValueManager;
import edu.psu.cse.siis.coal.arguments.MethodReturnValueManager;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformerManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.EntryPoints;
import soot.PackManager;
import soot.Scene;
import soot.SootClass;
import soot.Transform;
import soot.Value;
import soot.options.Options;

public class DefaultAnalysis<A extends CommandLineArguments>
extends Analysis<A> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void registerFieldTransformerFactories(A commandLineArguments) {
        FieldTransformerManager.v().registerDefaultFieldTransformerFactories();
    }

    @Override
    protected void registerArgumentValueAnalyses(A commandLineArguments) {
        ArgumentValueManager.v().registerDefaultArgumentValueAnalyses();
    }

    @Override
    protected void registerMethodReturnValueAnalyses(A commandLineArguments) {
        MethodReturnValueManager.v().registerDefaultMethodReturnValueAnalyses();
    }

    @Override
    protected void initializeAnalysis(A commandLineArguments) {
        this.addSceneTransformer();
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_output_format(12);
        Options.v().set_whole_program(true);
        Options.v().set_soot_classpath(((CommandLineArguments)commandLineArguments).getInput() + File.pathSeparator + ((CommandLineArguments)commandLineArguments).getClasspath());
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().setPhaseOption("jb.ulp", "off");
        Options.v().setPhaseOption("jb.uce", "remove-unreachable-traps:true");
        Options.v().setPhaseOption("cg", "trim-clinit:false");
        Options.v().set_prepend_classpath(true);
        Options.v().set_src_prec(4);
        for (String analysisClass : AnalysisParameters.v().getAnalysisClasses()) {
            SootClass sootClass = Scene.v().loadClassAndSupport(analysisClass);
            Scene.v().forceResolve(analysisClass, 3);
            sootClass.setApplicationClass();
        }
        Scene.v().loadNecessaryClasses();
        Scene.v().setMainClassFromOptions();
        Scene.v().setEntryPoints(EntryPoints.v().application());
    }

    @Override
    protected void handleFatalAnalysisException(A commandLineArguments, FatalAnalysisException exception) {
        this.logger.error("Fatal error while analyzing application", exception);
    }

    @Override
    protected void processResults(A commandLineArguments) {
        DefaultResultProcessor processor = new DefaultResultProcessor();
        processor.processResult();
    }

    @Override
    protected void finalizeAnalysis(A commandLineArguments) {
    }

    private void addSceneTransformer() {
        DefaultResultBuilder resultBuilder = new DefaultResultBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String debugDirPath = System.getProperty("user.home") + File.separator + "debug";
        File debugDir = new File(debugDirPath);
        if (!debugDir.exists()) {
            debugDir.mkdir();
        }
        String fileName = dateFormat.format(new Date()) + ".txt";
        String debugFilename = debugDirPath + File.separator + fileName;
        String pack = AnalysisParameters.v().useShimple() ? "wstp" : "wjtp";
        Transform transform = new Transform(pack + ".ifds", new PropagationSceneTransformer(resultBuilder, new PropagationSceneTransformerFilePrinter(debugFilename, new SymbolFilter(){

            @Override
            public boolean filterOut(Value symbol2) {
                return false;
            }
        })));
        if (PackManager.v().getPack(pack).get(pack + ".ifds") == null) {
            PackManager.v().getPack(pack).add(transform);
        } else {
            Iterator<Transform> it = PackManager.v().getPack(pack).iterator();
            while (it.hasNext()) {
                Transform current = it.next();
                if (!(current instanceof Transform) || !current.getPhaseName().equals(pack + ".ifds")) continue;
                it.remove();
                break;
            }
            PackManager.v().getPack(pack).add(transform);
        }
    }
}

