/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.Scene;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.spark.sets.EmptyPointsToSet;

public class FunctionFactoryUtils {
    private static final Logger logger = LoggerFactory.getLogger(FunctionFactoryUtils.class);
    private static PointsToAnalysis pointsToAnalysis = null;

    public static PointsToSet getPointsToSetForValue(Value value) {
        if (pointsToAnalysis == null) {
            pointsToAnalysis = Scene.v().getPointsToAnalysis();
        }
        if (value instanceof Local) {
            return pointsToAnalysis.reachingObjects((Local)value);
        }
        if (value instanceof InstanceFieldRef) {
            InstanceFieldRef sootFieldRef = (InstanceFieldRef)value;
            PointsToSet refPointsToSet = pointsToAnalysis.reachingObjects((Local)sootFieldRef.getBase());
            return pointsToAnalysis.reachingObjects(refPointsToSet, sootFieldRef.getField());
        }
        if (value instanceof StaticFieldRef) {
            StaticFieldRef sootFieldRef = (StaticFieldRef)value;
            return pointsToAnalysis.reachingObjects(sootFieldRef.getField());
        }
        if (value instanceof ArrayRef) {
            ArrayRef arrayRef = (ArrayRef)value;
            PointsToSet arrayPointsToSet = pointsToAnalysis.reachingObjects((Local)arrayRef.getBase());
            return pointsToAnalysis.reachingObjectsOfArrayElement(arrayPointsToSet);
        }
        return EmptyPointsToSet.v();
    }

    public static int shouldPropagateSource(Value source, List<Value> arguments) {
        if (logger.isDebugEnabled()) {
            logger.debug("**Source: " + source);
        }
        for (int i = 0; i < arguments.size(); ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug("**Argument: " + arguments.get(i));
            }
            if (!FunctionFactoryUtils.sourcePointsToArgument(source, arguments.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean shouldPropagateInstanceField(InstanceFieldRef instanceFieldRef, InvokeExpr invokeExpr) {
        Value invokeExprBase;
        Value fieldBase = instanceFieldRef.getBase();
        List<Value> argList = invokeExpr.getArgs();
        for (int i = 0; i < argList.size(); ++i) {
            if (!FunctionFactoryUtils.sourcePointsToArgument(fieldBase, argList.get(i))) continue;
            return true;
        }
        return invokeExpr instanceof InstanceInvokeExpr && FunctionFactoryUtils.sourcePointsToArgument(fieldBase, invokeExprBase = ((InstanceInvokeExpr)invokeExpr).getBase());
    }

    private static boolean sourcePointsToArgument(Value source, Value argument) {
        PointsToSet sourcePointsToSet = FunctionFactoryUtils.getPointsToSetForValue(source);
        PointsToSet argumentPointsToSet = FunctionFactoryUtils.getPointsToSetForValue(argument);
        if (logger.isDebugEnabled()) {
            logger.debug(source + " " + argument + ": " + source.equivTo(argument) + " - " + sourcePointsToSet.hasNonEmptyIntersection(argumentPointsToSet));
        }
        return source.equivTo(argument) || sourcePointsToSet.hasNonEmptyIntersection(argumentPointsToSet);
    }
}

