/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import com.google.common.base.Objects;
import edu.psu.cse.siis.coal.PropagationSolver;
import edu.psu.cse.siis.coal.arguments.ArgumentValueManager;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformer;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformerManager;
import edu.psu.cse.siis.coal.field.values.FieldValue;
import edu.psu.cse.siis.coal.values.BasePropagationValue;
import edu.psu.cse.siis.coal.values.PropagationValue;
import edu.psu.cse.siis.coal.values.TopPropagationValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Unit;
import soot.Value;

public class IterationSolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PropagationSolver solver = null;
    private static IterationSolver instance = new IterationSolver();
    private Set<LocationIdentifier> currentTopValues;
    private Set<LocationIdentifier> previousTopValues;

    public static IterationSolver v() {
        return instance;
    }

    public boolean hasFoundFixedPoint() {
        return this.currentTopValues.isEmpty() || this.currentTopValues.equals(this.previousTopValues);
    }

    public synchronized void initialize(PropagationSolver propagationSolver) {
        this.solver = propagationSolver;
        this.previousTopValues = this.currentTopValues;
        this.currentTopValues = new HashSet<LocationIdentifier>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FieldTransformer> makeTransformersFromReferencedValue(Unit stmt, Value symbol2, String field, String type, String operation) {
        BasePropagationValue referencedBaseValue;
        IterationSolver iterationSolver = this;
        synchronized (iterationSolver) {
            if (this.solver == null) {
                this.currentTopValues.add(new LocationIdentifier(stmt, symbol2, field, type, operation));
                return Collections.singleton(ArgumentValueManager.v().getTopFieldTransformer(type, operation));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Making transformer for " + symbol2 + " for " + field + " at \n" + stmt);
        }
        if ((referencedBaseValue = (BasePropagationValue)this.solver.resultAt(stmt, symbol2)) == null || referencedBaseValue instanceof TopPropagationValue) {
            this.logger.info("Found top at " + stmt);
            IterationSolver iterationSolver2 = this;
            synchronized (iterationSolver2) {
                this.currentTopValues.add(new LocationIdentifier(stmt, symbol2, field, type, operation));
            }
            return Collections.singleton(ArgumentValueManager.v().getTopFieldTransformer(type, operation));
        }
        PropagationValue referencedPropagationValue = (PropagationValue)referencedBaseValue;
        Set<FieldValue> fieldValues = referencedPropagationValue.getValuesForField(field);
        HashSet<FieldTransformer> result = new HashSet<FieldTransformer>();
        for (FieldValue fieldValue : fieldValues) {
            if (fieldValue != null) {
                result.add(FieldTransformerManager.v().makeFieldTransformer(operation, fieldValue.getValue()));
                continue;
            }
            result.add(null);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Returning " + ((Object)result).toString());
        }
        return result;
    }

    private static final class LocationIdentifier {
        private final Unit stmt;
        private final Value symbol;
        private final String field;
        private final String type;
        private final String operation;

        public LocationIdentifier(Unit stmt, Value symbol2, String field, String type, String operation) {
            this.stmt = stmt;
            this.symbol = symbol2;
            this.field = field;
            this.type = type;
            this.operation = operation;
        }

        public int hashCode() {
            return Objects.hashCode(this.stmt, this.symbol, this.field, this.type, this.operation);
        }

        public boolean equals(Object other) {
            if (other instanceof LocationIdentifier) {
                LocationIdentifier locationIdentifier = (LocationIdentifier)other;
                return Objects.equal(this.stmt, locationIdentifier.stmt) && Objects.equal(this.symbol, locationIdentifier.symbol) && Objects.equal(this.field, locationIdentifier.field) && Objects.equal(this.type, locationIdentifier.type) && Objects.equal(this.operation, locationIdentifier.operation);
            }
            return false;
        }
    }
}

