/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.ExtendedSignature;
import edu.psu.cse.siis.coal.MethodDescription;
import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.lang.ParseException;
import edu.psu.cse.siis.coal.lang.PropagationParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Value;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public class Model
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Model instance;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<String> modeledTypes = new HashSet<String>();
    private Map<String, MethodDescription> signatureToArgumentsMap = new HashMap<String, MethodDescription>();
    private Map<String, MethodDescription> genSignatureToArgumentsMap = new HashMap<String, MethodDescription>();
    private Map<String, MethodDescription> copySignatureToArgumentsMap = new HashMap<String, MethodDescription>();
    private Map<String, MethodDescription> sourceSignatureToArgumentsMap = new HashMap<String, MethodDescription>();
    private Map<String, Argument[]> copyConstructors = new HashMap<String, Argument[]>();
    private Map<String, Argument[]> staticFieldToArgumentsMap = new HashMap<String, Argument[]>();
    private Map<String, MethodDescription> queryToMethodDescriptionMap = new HashMap<String, MethodDescription>();
    private Set<String> excludedClasses = new HashSet<String>();

    public static Model v() {
        if (instance == null) {
            throw new RuntimeException("Model was not initialized. Please make sure you call loadModelFromDirectory(), loadModelFromFile() or loadCompiledModelFromFile()");
        }
        return instance;
    }

    public Set<String> getModeledTypes() {
        return this.modeledTypes;
    }

    public static void loadModel(String modelPaths) throws FileNotFoundException, ParseException {
        String[] modelPathsParts;
        for (String modelPath : modelPathsParts = modelPaths.split(File.pathSeparator)) {
            File file = new File(modelPath);
            if (file.isDirectory()) {
                Model.loadModelFromDirectory(modelPath);
                continue;
            }
            Model.loadModelFromFile(modelPath);
        }
    }

    public static void loadModelFromDirectory(String modelDir) throws FileNotFoundException, ParseException {
        if (instance == null) {
            instance = new Model();
        }
        PropagationParser.parseModelFromDirectory(instance, modelDir);
        instance.endInitialization();
    }

    public static void loadModelFromFile(String modelFilePath) throws FileNotFoundException, ParseException {
        if (instance == null) {
            instance = new Model();
        }
        PropagationParser.parseModelFromFile(instance, new File(modelFilePath));
    }

    public static void loadModelFromCompiledFile(String compiledModelFilePath) throws IOException, ClassNotFoundException {
        InputStream inputStream = compiledModelFilePath.startsWith("/res/") ? Model.class.getResourceAsStream(compiledModelFilePath) : new FileInputStream(compiledModelFilePath);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        instance = (Model)objectInputStream.readObject();
    }

    public boolean isModeledType(String type) {
        return this.modeledTypes.contains(type);
    }

    public Argument[] getArgumentsForMethod(InvokeExpr invokeExpr) {
        return this.getArgumentsFromMethodDescription(this.signatureToArgumentsMap, invokeExpr);
    }

    public Argument[] getArgumentsForGenMethod(InvokeExpr invokeExpr) {
        return this.getArgumentsFromMethodDescription(this.genSignatureToArgumentsMap, invokeExpr);
    }

    public Argument[] getArgumentsForCopyMethod(InvokeExpr invokeExpr) {
        return this.getArgumentsFromMethodDescription(this.copySignatureToArgumentsMap, invokeExpr);
    }

    public Argument[] getArgumentsForCopyConstructor(String signature) {
        return this.copyConstructors.get(signature);
    }

    public Argument[] getArgumentsForCopyConstructor(SootMethodRef methodRef) {
        return this.getArgumentsForCopyConstructor(methodRef.getSignature());
    }

    public Argument[] getArgumentsForSource(InvokeExpr invokeExpr) {
        return this.getArgumentsFromMethodDescription(this.sourceSignatureToArgumentsMap, invokeExpr);
    }

    public Argument[] getArgumentsForQuery(Stmt stmt) {
        if (stmt.containsInvokeExpr()) {
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            SootMethod method = invokeExpr.getMethod();
            if (AnalysisParameters.v().isAnalysisClass(method.getDeclaringClass().getName()) && method.isConcrete() && method.hasActiveBody()) {
                MethodDescription description = this.queryToMethodDescriptionMap.get(method.getSignature());
                if (description == null) {
                    return null;
                }
                return description.getArguments();
            }
            return this.getArgumentsFromMethodDescription(this.queryToMethodDescriptionMap, invokeExpr);
        }
        return null;
    }

    public Argument[] getArgumentsForStaticField(String signature) {
        return this.staticFieldToArgumentsMap.get(signature);
    }

    private Argument[] getArgumentsFromMethodDescription(Map<String, MethodDescription> signatureToMethodDescriptionMap, InvokeExpr invokeExpr) {
        String baseType;
        SootMethod method = invokeExpr.getMethod();
        String signature = method.getSignature();
        MethodDescription methodDescription = signatureToMethodDescriptionMap.get(signature);
        if (methodDescription != null) {
            return methodDescription.getArguments();
        }
        signature = method.getSubSignature();
        methodDescription = signatureToMethodDescriptionMap.get(signature);
        if (methodDescription == null) {
            return null;
        }
        String superclassName = methodDescription.getBaseClass();
        if (superclassName == null || !Scene.v().containsClass(superclassName) || invokeExpr instanceof InterfaceInvokeExpr) {
            return null;
        }
        SootClass superclass = Scene.v().getSootClass(superclassName);
        if (invokeExpr instanceof InstanceInvokeExpr) {
            Value baseValue = ((InstanceInvokeExpr)invokeExpr).getBase();
            baseType = baseValue.getType().toString();
        } else {
            baseType = invokeExpr.getMethod().getDeclaringClass().getName();
        }
        if (Scene.v().containsClass(baseType) && Scene.v().getActiveHierarchy().isClassSubclassOfIncluding(Scene.v().getSootClass(baseType), superclass)) {
            return methodDescription.getArguments();
        }
        return null;
    }

    public boolean isExcludedClass(String name) {
        return this.excludedClasses.contains(name);
    }

    public void addModeledType(String type) {
        this.modeledTypes.add(type);
    }

    public void addModifier(ExtendedSignature extendedSignature, Argument[] arguments, String modifierModifier) {
        MethodDescription methodDescription = new MethodDescription(extendedSignature.getSuperclass(), arguments);
        String signature = extendedSignature.getSignature();
        if (modifierModifier == null) {
            this.signatureToArgumentsMap.put(signature, methodDescription);
        } else if (modifierModifier.equals("gen")) {
            this.genSignatureToArgumentsMap.put(signature, methodDescription);
        } else if (modifierModifier.equals("copy")) {
            this.copySignatureToArgumentsMap.put(signature, methodDescription);
        } else {
            throw new RuntimeException("Unknown modifier modifier: " + modifierModifier);
        }
    }

    public void addSource(ExtendedSignature extendedSignature, Argument[] arguments) {
        MethodDescription methodDescription = new MethodDescription(extendedSignature.getSuperclass(), arguments);
        this.sourceSignatureToArgumentsMap.put(extendedSignature.getSignature(), methodDescription);
    }

    public void addCopyConstructor(String signature, Argument[] arguments) {
        this.copyConstructors.put(signature, arguments);
    }

    public void addQuery(ExtendedSignature extendedSignature, Argument[] arguments) {
        MethodDescription methodDescription = new MethodDescription(extendedSignature.getSuperclass(), arguments);
        this.queryToMethodDescriptionMap.put(extendedSignature.getSignature(), methodDescription);
    }

    public void addConstant(String signature, Argument[] arguments) {
        this.staticFieldToArgumentsMap.put(signature, arguments);
    }

    public void addExcludedClass(String name) {
        this.excludedClasses.add(name);
    }

    public void endInitialization() {
        this.modeledTypes = Collections.unmodifiableSet(this.modeledTypes);
        this.signatureToArgumentsMap = Collections.unmodifiableMap(this.signatureToArgumentsMap);
        this.genSignatureToArgumentsMap = Collections.unmodifiableMap(this.genSignatureToArgumentsMap);
        this.copySignatureToArgumentsMap = Collections.unmodifiableMap(this.copySignatureToArgumentsMap);
        this.sourceSignatureToArgumentsMap = Collections.unmodifiableMap(this.sourceSignatureToArgumentsMap);
        this.copyConstructors = Collections.unmodifiableMap(this.copyConstructors);
        this.staticFieldToArgumentsMap = Collections.unmodifiableMap(this.staticFieldToArgumentsMap);
        this.queryToMethodDescriptionMap = Collections.unmodifiableMap(this.queryToMethodDescriptionMap);
        this.excludedClasses = Collections.unmodifiableSet(this.excludedClasses);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("*****Model*****\n");
        stringBuilder.append("**Modeled Types**\n");
        stringBuilder.append(this.modeledTypes).append("\n");
        stringBuilder.append("\n**Modifiers**\n");
        for (Map.Entry<String, MethodDescription> entry : this.signatureToArgumentsMap.entrySet()) {
            stringBuilder.append(entry.getKey()).append("\n");
            stringBuilder.append(entry.getValue()).append("\n");
        }
        stringBuilder.append("\n**Generating Modifiers**\n");
        for (Map.Entry<String, MethodDescription> entry : this.genSignatureToArgumentsMap.entrySet()) {
            stringBuilder.append(entry.getKey()).append("\n");
            stringBuilder.append(entry.getValue()).append("\n");
        }
        stringBuilder.append("\n**Copy Modifiers**\n");
        for (Map.Entry<String, MethodDescription> entry : this.copySignatureToArgumentsMap.entrySet()) {
            stringBuilder.append(entry.getKey()).append("\n");
            stringBuilder.append(entry.getValue()).append("\n");
        }
        stringBuilder.append("\n**Sources**\n");
        for (Map.Entry<String, MethodDescription> entry : this.sourceSignatureToArgumentsMap.entrySet()) {
            stringBuilder.append(entry.getKey()).append("\n");
            stringBuilder.append(entry.getValue()).append("\n");
        }
        stringBuilder.append("\n**Copy Constructors**\n");
        for (Map.Entry<String, MethodDescription> entry : this.copyConstructors.entrySet()) {
            stringBuilder.append(entry.getKey()).append("\n");
            for (Argument argument : (Argument[])entry.getValue()) {
                stringBuilder.append("    " + argument.toString()).append("\n");
            }
        }
        stringBuilder.append("\n**Static Fields**\n");
        for (Map.Entry<String, MethodDescription> entry : this.staticFieldToArgumentsMap.entrySet()) {
            stringBuilder.append(entry.getKey()).append("\n");
            for (Argument argument : (Argument[])entry.getValue()) {
                stringBuilder.append("    " + argument.toString()).append("\n");
            }
        }
        stringBuilder.append("\n**Queries**\n");
        for (Map.Entry<String, MethodDescription> entry : this.queryToMethodDescriptionMap.entrySet()) {
            stringBuilder.append(entry.getKey()).append("\n");
            stringBuilder.append(entry.getValue().toString()).append("\n");
        }
        stringBuilder.append("\n**Excluded Classes**\n");
        stringBuilder.append(this.excludedClasses).append("\n");
        return stringBuilder.toString();
    }

    public void dump() {
        System.out.println(this.toString());
    }

    private Model() {
    }
}

