/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.transformers.PropagationTransformerFactory;
import edu.psu.cse.siis.coal.values.BasePropagationValue;
import heros.EdgeFunction;
import heros.edgefunc.EdgeIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.PointsToAnalysis;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.NullConstant;
import soot.jimple.StaticFieldRef;

public class NormalEdgeFunctionFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public EdgeFunction<BasePropagationValue> getNormalEdgeFunction(Unit curr, Value currNode, Value succNode, Value zeroValue, PointsToAnalysis pointsToAnalysis) {
        if (curr instanceof AssignStmt) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Normal edge: " + curr);
                this.logger.debug(currNode + " " + succNode);
            }
            AssignStmt assignStmt = (AssignStmt)curr;
            Value left = assignStmt.getLeftOp();
            String type = left.getType().toString();
            Value right = assignStmt.getRightOp();
            if (Model.v().isModeledType(type) && currNode.equivTo(zeroValue) && succNode.equivTo(left)) {
                if (right instanceof StaticFieldRef) {
                    StaticFieldRef staticFieldRef = (StaticFieldRef)right;
                    Argument[] arguments = Model.v().getArgumentsForStaticField(staticFieldRef.getField().getSignature());
                    EdgeFunction<BasePropagationValue> result = PropagationTransformerFactory.makeTransformer(null, arguments, false);
                    if (arguments != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Returning " + result);
                        }
                        return PropagationTransformerFactory.makeTransformer(null, arguments, false);
                    }
                } else if (right instanceof NullConstant) {
                    return PropagationTransformerFactory.makeTransformer(null, null, false);
                }
            }
        }
        return EdgeIdentity.v();
    }
}

