/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.Model;
import heros.FlowFunction;
import heros.flowfunc.Identity;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Hierarchy;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.Scene;
import soot.SootClass;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.NullConstant;
import soot.jimple.StaticFieldRef;
import soot.shimple.PhiExpr;
import soot.shimple.PiExpr;

public class NormalFlowFunctionFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FlowFunction<Value> getNormalFlowFunction(final Unit src, Unit dest, final Value zeroValue, final PointsToAnalysis pointsToAnalysis) {
        if (src instanceof AssignStmt) {
            final AssignStmt definitionStmt = (AssignStmt)src;
            final Value left = definitionStmt.getLeftOp();
            final String type = left.getType().toString();
            if (Model.v().isModeledType(type)) {
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        if (NormalFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            NormalFlowFunctionFactory.this.logger.debug("Normal flow stmt: " + src);
                        }
                        Value right = definitionStmt.getRightOp();
                        HashSet<Value> res = new HashSet<Value>();
                        if (NormalFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            NormalFlowFunctionFactory.this.logger.debug("Source: " + source + " " + (source instanceof StaticFieldRef) + " " + (right instanceof StaticFieldRef));
                        }
                        if (source.equivTo(zeroValue) && right instanceof StaticFieldRef) {
                            StaticFieldRef rightFieldRef = (StaticFieldRef)right;
                            if (Model.v().getArgumentsForStaticField(rightFieldRef.getField().getSignature()) != null) {
                                if (NormalFlowFunctionFactory.this.logger.isDebugEnabled()) {
                                    NormalFlowFunctionFactory.this.logger.debug("Adding constant");
                                }
                                res.add(left);
                            }
                        } else if (source.equivTo(zeroValue) && right instanceof NullConstant) {
                            res.add(left);
                        } else if (source instanceof InstanceFieldRef && right instanceof InstanceFieldRef) {
                            PointsToSet rightBasePointsToSet;
                            InstanceFieldRef sourceFieldRef = (InstanceFieldRef)source;
                            InstanceFieldRef rightFieldRef = (InstanceFieldRef)right;
                            PointsToSet sourceBasePointsToSet = pointsToAnalysis.reachingObjects((Local)sourceFieldRef.getBase());
                            if (sourceBasePointsToSet.hasNonEmptyIntersection(rightBasePointsToSet = pointsToAnalysis.reachingObjects((Local)rightFieldRef.getBase()))) {
                                PointsToSet sourceFieldPointsToSet = pointsToAnalysis.reachingObjects(sourceBasePointsToSet, sourceFieldRef.getField());
                                PointsToSet rightFieldPointsToSet = pointsToAnalysis.reachingObjects(rightBasePointsToSet, rightFieldRef.getField());
                                if (sourceFieldRef.getField().getSubSignature().equals(rightFieldRef.getField().getSubSignature()) || sourceFieldPointsToSet.hasNonEmptyIntersection(rightFieldPointsToSet)) {
                                    res.add(left);
                                }
                            }
                        } else if (source instanceof StaticFieldRef && right instanceof StaticFieldRef) {
                            StaticFieldRef sourceFieldRef = (StaticFieldRef)source;
                            StaticFieldRef rightFieldRef = (StaticFieldRef)right;
                            PointsToSet sourcePointsToSet = pointsToAnalysis.reachingObjects(sourceFieldRef.getField());
                            PointsToSet rightPointsToSet = pointsToAnalysis.reachingObjects(rightFieldRef.getField());
                            if (source.toString().equals(right.toString()) || sourcePointsToSet.hasNonEmptyIntersection(rightPointsToSet) || NormalFlowFunctionFactory.this.haveCommonFields(sourceFieldRef.getFieldRef().declaringClass(), rightFieldRef.getFieldRef().declaringClass())) {
                                res.add(left);
                            }
                        } else if (source.equivTo(right) || source.equals(zeroValue) || right instanceof PhiExpr && ((PhiExpr)right).getValues().contains(source) || right instanceof PiExpr && ((PiExpr)right).getValue().equals(source)) {
                            res.add(left);
                        } else if (right instanceof ArrayRef && source.equivTo(((ArrayRef)right).getBase())) {
                            res.add(left);
                        }
                        if (source.equivTo(zeroValue)) {
                            res.add(source);
                        }
                        if (!(source.equivTo(left) || source.equals(zeroValue) || source.toString().equals(left.toString()) && Model.v().isModeledType(type))) {
                            res.add(source);
                        }
                        if (NormalFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            NormalFlowFunctionFactory.this.logger.debug("Returning " + res);
                        }
                        return res;
                    }
                };
            }
        }
        return Identity.v();
    }

    public boolean haveCommonFields(SootClass sootClass1, SootClass sootClass2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(sootClass1 + "\n" + sootClass2);
        }
        boolean haveCommonFields = false;
        Hierarchy hierarchy = Scene.v().getActiveHierarchy();
        if (sootClass1.isInterface()) {
            if (sootClass2.isInterface()) {
                boolean bl = haveCommonFields = hierarchy.isInterfaceSubinterfaceOf(sootClass1, sootClass2) || hierarchy.isInterfaceSuperinterfaceOf(sootClass1, sootClass2);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("1: " + haveCommonFields);
                }
            } else {
                haveCommonFields = sootClass2.implementsInterface(sootClass1.getName());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("2: " + haveCommonFields);
                }
            }
        } else if (sootClass2.isInterface()) {
            haveCommonFields = sootClass1.implementsInterface(sootClass2.getName());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("3: " + haveCommonFields);
            }
        } else {
            boolean bl = haveCommonFields = hierarchy.isClassSubclassOf(sootClass1, sootClass2) || hierarchy.isClassSuperclassOf(sootClass1, sootClass2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("4: " + haveCommonFields);
            }
        }
        return haveCommonFields;
    }
}

