/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.IterationSolver;
import edu.psu.cse.siis.coal.PropagationIcfg;
import edu.psu.cse.siis.coal.PropagationProblem;
import edu.psu.cse.siis.coal.PropagationSceneTransformerPrinter;
import edu.psu.cse.siis.coal.PropagationSolver;
import edu.psu.cse.siis.coal.PropagationTimers;
import edu.psu.cse.siis.coal.ResultBuilder;
import edu.psu.cse.siis.coal.Results;
import edu.psu.cse.siis.coal.arguments.StringValueAnalysis;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.queue.QueueReader;

public class PropagationSceneTransformer
extends SceneTransformer {
    private static final int MAX_ITERATIONS = 15;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResultBuilder resultBuilder;
    private final PropagationSceneTransformerPrinter printer;

    public PropagationSceneTransformer(ResultBuilder resultBuilder, PropagationSceneTransformerPrinter printer) {
        this.resultBuilder = resultBuilder;
        this.printer = printer;
    }

    protected void internalTransform(String phaseName, Map options) {
        PropagationTimers.v().totalTimer.start();
        PropagationTimers.v().misc.start();
        StringValueAnalysis.initialize();
        PropagationIcfg iCfg = new PropagationIcfg();
        AnalysisParameters.v().setIcfg(iCfg);
        PropagationProblem problem = new PropagationProblem(iCfg);
        for (SootMethod ep : Scene.v().getEntryPoints()) {
            if (!ep.isConcrete()) continue;
            problem.getInitialSeeds().add((Unit)ep.getActiveBody().getUnits().getFirst());
        }
        int iterationCounter = 0;
        PropagationSolver solver = null;
        while (iterationCounter < 15) {
            IterationSolver.v().initialize(solver);
            PropagationTimers.v().misc.end();
            PropagationTimers.v().problemGeneration.start();
            solver = new PropagationSolver(problem);
            PropagationTimers.v().problemGeneration.end();
            PropagationTimers.v().ideSolution.start();
            this.logger.info("Solving propagation problem (iteration " + iterationCounter + ")");
            solver.solve();
            PropagationTimers.v().ideSolution.end();
            PropagationTimers.v().misc.start();
            if (!AnalysisParameters.v().isIterative() || IterationSolver.v().hasFoundFixedPoint()) {
                iterationCounter = 15;
                continue;
            }
            ++iterationCounter;
        }
        PropagationTimers.v().misc.end();
        this.logger.info("Reached a fixed point");
        Results.addResult(this.resultBuilder.buildResult(solver));
        PropagationTimers.v().totalTimer.end();
        if (this.logger.isDebugEnabled()) {
            CallGraph cg = Scene.v().getCallGraph();
            QueueReader<Edge> it = cg.listener();
            while (it.hasNext()) {
                Edge e = (Edge)it.next();
                this.logger.debug("" + e.src() + e.srcStmt() + " =" + e.kind() + "=> " + e.tgt());
            }
            if (this.printer != null) {
                this.printer.print(solver);
            }
        }
    }
}

