/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.PropagationSceneTransformerPrinter;
import edu.psu.cse.siis.coal.PropagationSolver;
import edu.psu.cse.siis.coal.SymbolFilter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;

public class PropagationSceneTransformerFilePrinter
implements PropagationSceneTransformerPrinter {
    private final String filePath;
    private final SymbolFilter filter;

    public PropagationSceneTransformerFilePrinter(String filePath, SymbolFilter filter) {
        this.filePath = filePath;
        this.filter = filter;
    }

    @Override
    public void print(PropagationSolver solver) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.filePath));
            String newLine = System.getProperty("line.separator");
            ArrayList<SootMethod> eps = new ArrayList<SootMethod>(Scene.v().getEntryPoints());
            ReachableMethods reachableMethods = new ReachableMethods(Scene.v().getCallGraph(), eps.iterator(), null);
            reachableMethods.update();
            QueueReader<MethodOrMethodContext> iter = reachableMethods.listener();
            while (iter.hasNext()) {
                SootMethod ep = ((MethodOrMethodContext)iter.next()).method();
                if (!ep.isConcrete() || !ep.hasActiveBody()) continue;
                writer.write(ep.getActiveBody() + newLine);
                writer.write("----------------------------------------------" + newLine);
                writer.write("At end of: " + ep.getSignature() + newLine);
                writer.write("Variables:" + newLine);
                writer.write("----------------------------------------------" + newLine);
                for (Unit ret : ep.getActiveBody().getUnits()) {
                    for (Map.Entry l : solver.resultsAt(ret).entrySet()) {
                        Value symbol2 = (Value)l.getKey();
                        if (this.filter.filterOut(symbol2)) continue;
                        writer.write(symbol2 + " contains value " + l.getValue() + newLine);
                    }
                    writer.write("**" + ret + newLine);
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

