/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.Model;
import heros.FlowFunction;
import heros.flowfunc.KillAll;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;

public class ReturnFlowFunctionFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FlowFunction<Value> getReturnFlowFunction(final Unit callSite, SootMethod callee, Unit exitStmt, Unit retSite, Value zeroValue) {
        Stmt stmt = (Stmt)callSite;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Stmt: " + stmt);
        }
        if ("<clinit>".equals(callee.getName())) {
            return new FlowFunction<Value>(){

                @Override
                public Set<Value> computeTargets(Value source) {
                    if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                        ReturnFlowFunctionFactory.this.logger.debug("source: " + source);
                    }
                    if (callSite instanceof AssignStmt) {
                        AssignStmt assignStmt = (AssignStmt)callSite;
                        Value right = assignStmt.getRightOp();
                        if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            ReturnFlowFunctionFactory.this.logger.debug("right: " + right);
                        }
                        if (right instanceof StaticFieldRef && right.toString().equals(source.toString())) {
                            HashSet<Value> result = new HashSet<Value>();
                            result.add(source);
                            result.add(assignStmt.getLeftOp());
                            if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                                ReturnFlowFunctionFactory.this.logger.debug("Returning " + result);
                            }
                            return result;
                        }
                    } else if (source instanceof FieldRef) {
                        if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            ReturnFlowFunctionFactory.this.logger.debug("Returning " + source);
                        }
                        return Collections.singleton(source);
                    }
                    if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                        ReturnFlowFunctionFactory.this.logger.debug("Returning empty set");
                    }
                    return Collections.emptySet();
                }
            };
        }
        String declaringClass = callee.getDeclaringClass().getName();
        if (Model.v().getArgumentsForGenMethod(stmt.getInvokeExpr()) != null || Model.v().getArgumentsForCopyConstructor(stmt.getInvokeExpr().getMethodRef()) != null || !AnalysisParameters.v().isAnalysisClass(declaringClass)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Killing all");
            }
            return KillAll.v();
        }
        if (exitStmt instanceof ReturnStmt || exitStmt instanceof ReturnVoidStmt || exitStmt instanceof ThrowStmt) {
            final ArrayList<Local> paramLocals = new ArrayList<Local>();
            for (int i = 0; i < callee.getParameterCount(); ++i) {
                paramLocals.add(callee.getActiveBody().getParameterLocal(i));
            }
            if (callSite instanceof InvokeStmt) {
                InvokeStmt invokeStmt = (InvokeStmt)callSite;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Invoke Stmt: " + invokeStmt);
                }
                final InvokeExpr invokeExpr = invokeStmt.getInvokeExpr();
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            ReturnFlowFunctionFactory.this.logger.debug("Invoke expr: " + invokeExpr + "\nSource: " + source);
                        }
                        for (int i = 0; i < paramLocals.size(); ++i) {
                            if (!((Value)paramLocals.get(i)).equivTo(source)) continue;
                            return Collections.singleton(invokeExpr.getArg(i));
                        }
                        if (source instanceof FieldRef) {
                            if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                                ReturnFlowFunctionFactory.this.logger.debug("Detected and returning field ref");
                            }
                            return Collections.singleton(source);
                        }
                        if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            ReturnFlowFunctionFactory.this.logger.debug("Returning empty set");
                        }
                        return Collections.emptySet();
                    }
                };
            }
            if (callSite instanceof DefinitionStmt && !(exitStmt instanceof ThrowStmt) && !(exitStmt instanceof ReturnVoidStmt)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Stmt: " + callSite);
                }
                DefinitionStmt defnStmt = (DefinitionStmt)callSite;
                final Value leftOp = defnStmt.getLeftOp();
                ReturnStmt returnStmt = (ReturnStmt)exitStmt;
                final Value retLocal = returnStmt.getOp();
                final InvokeExpr invokeExpr = (InvokeExpr)defnStmt.getRightOp();
                return new FlowFunction<Value>(){

                    @Override
                    public Set<Value> computeTargets(Value source) {
                        if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            ReturnFlowFunctionFactory.this.logger.debug("source: " + source);
                        }
                        if (source.equivTo(retLocal)) {
                            if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                                ReturnFlowFunctionFactory.this.logger.debug("Returning " + Collections.singleton(leftOp));
                            }
                            return Collections.singleton(leftOp);
                        }
                        for (int i = 0; i < paramLocals.size(); ++i) {
                            if (!((Value)paramLocals.get(i)).equivTo(source)) continue;
                            if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                                ReturnFlowFunctionFactory.this.logger.debug("Returning " + Collections.singleton(invokeExpr.getArg(i)));
                            }
                            return Collections.singleton(invokeExpr.getArg(i));
                        }
                        if (source instanceof FieldRef) {
                            return Collections.singleton(source);
                        }
                        if (ReturnFlowFunctionFactory.this.logger.isDebugEnabled()) {
                            ReturnFlowFunctionFactory.this.logger.debug("Returning " + Collections.emptySet());
                        }
                        return Collections.emptySet();
                    }
                };
            }
        }
        return KillAll.v();
    }
}

