/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.Field;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Argument
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] argnum;
    private String type;
    private String[] actions;
    private String[] inlineValues;
    private Map<String, String> properties;
    private short count = (short)-1;
    private Field field;
    private String referencedFieldName;

    public Argument() {
    }

    public Argument(Argument other) {
        this.argnum = other.argnum;
        this.type = other.type;
        this.field = other.field;
        this.actions = other.actions;
        this.inlineValues = other.inlineValues;
        if (other.properties != null) {
            this.properties = new HashMap<String, String>(other.properties);
        }
        this.count = other.count;
    }

    public void setArgnum(int[] argnum) {
        this.argnum = argnum;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setActions(String[] actions2) {
        this.actions = actions2;
    }

    public void setInlineValues(String[] inlineValues) {
        this.inlineValues = inlineValues;
    }

    public void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public void setCount(short count) {
        this.count = count;
    }

    public void setReferencedFieldName(String referencedFieldName) {
        this.referencedFieldName = referencedFieldName;
    }

    public int[] getArgnum() {
        return this.argnum;
    }

    public String getType() {
        if (this.type == null) {
            return this.field.getType();
        }
        return this.type;
    }

    public String getNominalFieldType() {
        return this.field.getType();
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public String[] getActions() {
        return this.actions;
    }

    public String[] getInlineValues() {
        return this.inlineValues;
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getReferencedFieldName() {
        return this.referencedFieldName;
    }

    public short getCount() {
        return this.count;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        if (this.getArgnum() != null) {
            result.append("(");
            for (int argnum : this.getArgnum()) {
                if (first) {
                    first = false;
                } else {
                    result.append(",");
                }
                result.append(argnum);
            }
            result.append(") ");
        }
        result.append(this.getType());
        result.append(" ");
        result.append(this.getFieldName());
        result.append(" ");
        if (this.getActions() != null) {
            result.append("(");
            first = true;
            for (String action : this.getActions()) {
                if (first) {
                    first = false;
                } else {
                    result.append(",");
                }
                result.append(action);
            }
            result.append(")");
        }
        result.append(" ");
        if (this.getInlineValues() != null) {
            result.append("(");
            first = true;
            for (String inlineValue : this.getInlineValues()) {
                if (first) {
                    first = false;
                } else {
                    result.append(",");
                }
                result.append(inlineValue);
            }
            result.append(")");
        }
        return result.toString();
    }
}

