/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.arguments.Argument;
import java.util.Collections;
import java.util.Set;
import soot.Unit;
import soot.Value;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public abstract class ArgumentValueAnalysis {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<Object> computeArgumentValues(Argument argument, Unit callSite) {
        if (argument.getArgnum() == null) {
            return null;
        }
        if (AnalysisParameters.v().useShimple()) {
            return Collections.singleton(this.getTopValue());
        }
        Stmt stmt = (Stmt)callSite;
        if (!stmt.containsInvokeExpr()) {
            throw new RuntimeException("Statement " + stmt + " does not contain an invoke expression");
        }
        InvokeExpr invokeExpr = stmt.getInvokeExpr();
        int argnum = argument.getArgnum()[0];
        Value value = null;
        if (argnum == -1) {
            if (!(invokeExpr instanceof InstanceInvokeExpr)) throw new RuntimeException("Invoke expression has no base: " + invokeExpr);
            value = ((InstanceInvokeExpr)invokeExpr).getBase();
            return this.computeVariableValues(value, stmt);
        } else {
            value = stmt.getInvokeExpr().getArg(argnum);
        }
        return this.computeVariableValues(value, stmt);
    }

    public abstract Set<Object> computeVariableValues(Value var1, Stmt var2);

    public abstract Set<Object> computeInlineArgumentValues(String[] var1);

    public abstract Object getTopValue();
}

