/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.arguments.Argument;
import edu.psu.cse.siis.coal.arguments.ArgumentValueAnalysis;
import edu.psu.cse.siis.coal.arguments.ArgumentValueIdentifier;
import edu.psu.cse.siis.coal.arguments.ClassValueAnalysis;
import edu.psu.cse.siis.coal.arguments.IntValueAnalysis;
import edu.psu.cse.siis.coal.arguments.StringValueAnalysis;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformer;
import edu.psu.cse.siis.coal.field.transformers.FieldTransformerManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Unit;

public class ArgumentValueManager {
    private static final short MAX_TIME = 300;
    private static final short MIN_TIME = 120;
    private static final float DECREASE_FACTOR = 0.9f;
    private static final ArgumentValueManager instance = new ArgumentValueManager();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ArgumentValueAnalysis> argumentValueAnalysisMap = new HashMap<String, ArgumentValueAnalysis>();
    private final Map<ArgumentValueIdentifier, Set<Object>> cachedValues = new HashMap<ArgumentValueIdentifier, Set<Object>>();
    private final Map<String, FieldTransformer> topFieldTransformerMap = new HashMap<String, FieldTransformer>();
    private short timeBudget = (short)300;

    private ArgumentValueManager() {
    }

    public static ArgumentValueManager v() {
        return instance;
    }

    public void registerArgumentValueAnalysis(String type, ArgumentValueAnalysis analysis) {
        this.argumentValueAnalysisMap.put(type, analysis);
    }

    public ArgumentValueAnalysis getArgumentValueAnalysis(String type) {
        ArgumentValueAnalysis analysis = this.argumentValueAnalysisMap.get(type);
        if (analysis == null) {
            throw new RuntimeException("No analysis for type " + type);
        }
        return analysis;
    }

    public void registerDefaultArgumentValueAnalyses() {
        this.registerArgumentValueAnalysis("String", new StringValueAnalysis());
        this.registerArgumentValueAnalysis("Class", new ClassValueAnalysis());
        this.registerArgumentValueAnalysis("int", new IntValueAnalysis());
        this.registerArgumentValueAnalysis("Set<String>", new StringValueAnalysis());
        this.registerArgumentValueAnalysis("Set<Class>", new ClassValueAnalysis());
        this.registerArgumentValueAnalysis("Set<int>", new IntValueAnalysis());
    }

    public Set<Object> getArgumentValues(Argument argument, Unit callSite) {
        String type = argument.getType();
        if (type == null) {
            return null;
        }
        if (AnalysisParameters.v().isIterative()) {
            ArgumentValueIdentifier argumentValueIdentifier = new ArgumentValueIdentifier(callSite, argument);
            Set<Object> result = this.cachedValues.get(argumentValueIdentifier);
            if (result != null) {
                return result;
            }
            result = this.computeNewArgumentValues(argument, callSite);
            this.cachedValues.put(argumentValueIdentifier, result);
            return result;
        }
        return this.computeNewArgumentValues(argument, callSite);
    }

    public FieldTransformer getTopFieldTransformer(String type, String operation) {
        String key = type + "::" + operation;
        FieldTransformer fieldTransformer = this.topFieldTransformerMap.get(key);
        if (fieldTransformer == null) {
            fieldTransformer = this.makeTopFieldTransformer(type, operation);
            this.topFieldTransformerMap.put(key, fieldTransformer);
        }
        return fieldTransformer;
    }

    private FieldTransformer makeTopFieldTransformer(String type, String operation) {
        ArgumentValueAnalysis analysis = this.getArgumentValueAnalysis(type);
        return FieldTransformerManager.v().makeFieldTransformer(operation, analysis.getTopValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Object> computeNewArgumentValues(Argument argument, Unit callSite) {
        String type = argument.getType();
        String[] inlineValues = argument.getInlineValues();
        ArgumentValueAnalysis analysis = this.getArgumentValueAnalysis(type);
        if (inlineValues == null) {
            ExecutorService pool = Executors.newFixedThreadPool(1);
            Future<Set<Object>> valuesFuture = this.startComputingNewArgumentValues(pool, analysis, argument, callSite);
            try {
                Set<Object> set = valuesFuture.get(this.timeBudget, TimeUnit.SECONDS);
                return set;
            }
            catch (InterruptedException | ExecutionException | TimeoutException exc) {
                valuesFuture.cancel(true);
                Object object = this;
                synchronized (object) {
                    if (this.timeBudget > 120) {
                        this.timeBudget = (short)((float)this.timeBudget * 0.9f);
                        if (this.timeBudget < 120) {
                            this.timeBudget = (short)120;
                        }
                    }
                }
                this.logger.warn("Could not infer argument value at statement " + callSite.toString(), exc);
                object = Collections.singleton(analysis.getTopValue());
                return object;
            }
            catch (Error error) {
                valuesFuture.cancel(true);
                System.gc();
                this.logger.warn("Could not infer argument value at statement " + callSite.toString(), error);
                Set<Object> set = Collections.singleton(analysis.getTopValue());
                return set;
            }
            finally {
                pool.shutdownNow();
            }
        }
        return analysis.computeInlineArgumentValues(inlineValues);
    }

    private Future<Set<Object>> startComputingNewArgumentValues(ExecutorService pool, final ArgumentValueAnalysis analysis, final Argument argument, final Unit callSite) {
        Callable<Set<Object>> callable = new Callable<Set<Object>>(){

            @Override
            public Set<Object> call() {
                return analysis.computeArgumentValues(argument, callSite);
            }
        };
        return pool.submit(callable);
    }
}

