/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.arguments.ArgumentValueAnalysis;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.Pair;

public abstract class BackwardValueAnalysis
extends ArgumentValueAnalysis {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected List<DefinitionStmt> findAssignmentsForLocal(Unit start, Local local, boolean init, Set<Pair<Unit, Local>> visitedUnits) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finding assignments for local " + local);
        }
        SootMethod method = AnalysisParameters.v().getIcfg().getMethodOf(start);
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(method.getActiveBody());
        ArrayList<DefinitionStmt> result = new ArrayList<DefinitionStmt>();
        Stack<Unit> stack = new Stack<Unit>();
        stack.push(start);
        if (init) {
            visitedUnits.clear();
        }
        while (!stack.empty()) {
            AssignStmt assignStmt;
            Pair<Unit, Local> pair;
            Unit current = (Unit)stack.pop();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(current + " " + current.getClass());
            }
            if (visitedUnits.contains(pair = new Pair<Unit, Local>(current, local))) continue;
            visitedUnits.add(pair);
            if (current instanceof IdentityStmt) {
                IdentityStmt identityStmt = (IdentityStmt)current;
                if (identityStmt.getLeftOp().equivTo(local)) {
                    result.add(identityStmt);
                }
            } else if (current instanceof AssignStmt && (assignStmt = (AssignStmt)current).getLeftOp().equivTo(local)) {
                if (assignStmt.getRightOp() instanceof Local) {
                    result.addAll(this.findAssignmentsForLocal(current, (Local)assignStmt.getRightOp(), false, visitedUnits));
                    continue;
                }
                result.add(assignStmt);
                continue;
            }
            for (Unit pred : graph.getPredsOf(current)) {
                stack.push(pred);
            }
        }
        return result;
    }
}

