/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.CCVisitor;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.Res2Constr;
import soot.G;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EqExpr;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GtExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.JimpleValueSwitch;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LtExpr;
import soot.jimple.MethodHandle;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.ThisRef;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;

public class CCExprVisitor
implements JimpleValueSwitch {
    private final boolean dbg_all_string_functions_known = false;
    static int verbose_level = 0;
    Stmt stmt;
    LanguageConstraints.Box result;
    CCVisitor svis;
    SootMethod sm;

    protected void dbg0(String what, Value v) {
        G.v().out.println("DBG:ccExprVisitor." + what + " v=" + v + " class= " + v.getClass().getName() + " type= " + v.getType() + " type-class= " + v.getType().getClass().getName());
    }

    protected void ignore(String what, Value v) {
        if (verbose_level > 10) {
            this.dbg0(what, v);
        }
        this.result = LanguageConstraints.BottomBox();
    }

    protected void warning(String what, Value v) {
        if (verbose_level >= 1) {
            this.dbg0("WARNING/ERROR:" + what, v);
        }
        this.result = LanguageConstraints.BottomBox();
    }

    protected void dbg(String what, Value v) {
        if (verbose_level > 10) {
            this.dbg0(what, v);
        }
    }

    CCExprVisitor(CCVisitor svis0, SootMethod sm0) {
        this.svis = svis0;
        this.sm = sm0;
    }

    LanguageConstraints.Box eval(Value v) {
        Stmt old_stmt = this.stmt;
        this.result = null;
        assert (this.stmt != null);
        v.apply(this);
        this.stmt = old_stmt;
        return this.result;
    }

    LanguageConstraints.Box eval(Value v, Stmt s) {
        this.stmt = s;
        return this.eval(v);
    }

    LanguageConstraints.Box evalBase(InstanceInvokeExpr iiexpr) {
        Value base = iiexpr.getBase();
        return this.eval(base, this.stmt);
    }

    LanguageConstraints.Box evalArg(InvokeExpr iexpr, int arg_num) {
        Value v = iexpr.getArg(arg_num);
        return this.eval(v, this.stmt);
    }

    LanguageConstraints.Box[] evalArguments(InvokeExpr iexpr) {
        int num_args = iexpr.getArgCount();
        LanguageConstraints.Box[] res = new LanguageConstraints.Box[num_args];
        int i = 0;
        while (i < num_args) {
            Value v = iexpr.getArg(i);
            res[i] = this.eval(v, this.stmt);
            ++i;
        }
        return res;
    }

    boolean hasSignature(InvokeExpr iexpr, String str) {
        SootMethod sm = iexpr.getMethod();
        String m_signature = sm.getSignature();
        return m_signature.equals(str);
    }

    boolean hasPrefixSignature(InvokeExpr iexpr, String prefix) {
        SootMethod sm = iexpr.getMethod();
        String m_signature = sm.getSignature();
        return m_signature.startsWith(prefix);
    }

    LanguageConstraints.Box getCaleeAndPutCallArguments(Stmt stmt, LanguageConstraints.Box[] arguments) {
        Res2Constr.putCallArguments(this.sm, stmt, arguments);
        return new LanguageConstraints.Box(new LanguageConstraints.Call(this.sm, stmt, arguments));
    }

    @Override
    public void caseDoubleConstant(DoubleConstant v) {
        this.ignore("caseDoubleConstant", v);
    }

    @Override
    public void caseFloatConstant(FloatConstant v) {
        this.ignore("caseFloatConstant", v);
    }

    @Override
    public void caseIntConstant(IntConstant v) {
        this.ignore("caseIntConstant", v);
    }

    @Override
    public void caseLongConstant(LongConstant v) {
        this.ignore("caseLongConstant", v);
    }

    @Override
    public void caseNullConstant(NullConstant v) {
        this.dbg("caseNullConstant", v);
        this.result = LanguageConstraints.NullConstantBox();
    }

    @Override
    public void caseStringConstant(StringConstant v) {
        this.dbg("caseStringConstant", v);
        String str = v.value;
        this.result = new LanguageConstraints.Box(new LanguageConstraints.Terminal(str));
    }

    @Override
    public void caseClassConstant(ClassConstant v) {
        this.ignore("caseClassConstant", v);
    }

    @Override
    public void caseAddExpr(AddExpr v) {
        this.ignore("caseAddExpr", v);
    }

    @Override
    public void caseAndExpr(AndExpr v) {
        this.ignore("caseAndExpr", v);
    }

    @Override
    public void caseCmpExpr(CmpExpr v) {
        this.ignore("caseCmpExpr", v);
    }

    @Override
    public void caseCmpgExpr(CmpgExpr v) {
        this.ignore("caseCmpgExpr", v);
    }

    @Override
    public void caseCmplExpr(CmplExpr v) {
        this.ignore("caseCmplExpr", v);
    }

    @Override
    public void caseDivExpr(DivExpr v) {
        this.ignore("caseDivExpr", v);
    }

    @Override
    public void caseEqExpr(EqExpr v) {
        this.ignore("caseEqExpr", v);
    }

    @Override
    public void caseNeExpr(NeExpr v) {
        this.ignore("caseNeExpr", v);
    }

    @Override
    public void caseGeExpr(GeExpr v) {
        this.ignore("caseGeExpr", v);
    }

    @Override
    public void caseGtExpr(GtExpr v) {
        this.ignore("caseGtExpr", v);
    }

    @Override
    public void caseLeExpr(LeExpr v) {
        this.ignore("caseLeExpr", v);
    }

    @Override
    public void caseLtExpr(LtExpr v) {
        this.ignore("caseLtExpr", v);
    }

    @Override
    public void caseMulExpr(MulExpr v) {
        this.ignore("caseMulExpr", v);
    }

    @Override
    public void caseOrExpr(OrExpr v) {
        this.ignore("caseOrExpr", v);
    }

    @Override
    public void caseRemExpr(RemExpr v) {
        this.ignore("caseRemExpr", v);
    }

    @Override
    public void caseShlExpr(ShlExpr v) {
        this.ignore("caseShlExpr", v);
    }

    @Override
    public void caseShrExpr(ShrExpr v) {
        this.ignore("caseShrExpr", v);
    }

    @Override
    public void caseUshrExpr(UshrExpr v) {
        this.ignore("caseUshrExpr", v);
    }

    @Override
    public void caseSubExpr(SubExpr v) {
        this.ignore("caseSubExpr", v);
    }

    @Override
    public void caseXorExpr(XorExpr v) {
        this.ignore("caseXorExpr", v);
    }

    @Override
    public void caseInterfaceInvokeExpr(InterfaceInvokeExpr v) {
        this.ignore("caseInterfaceInvokeExpr", v);
    }

    @Override
    public void caseSpecialInvokeExpr(SpecialInvokeExpr v) {
        this.dbg("caseSpecialInvokeExpr", v);
        if (this.hasSignature(v, "<java.lang.StringBuilder: void <init>(java.lang.String)>")) {
            this.result = this.evalArg(v, 0);
            return;
        }
        if (this.hasSignature(v, "<java.lang.StringBuilder: void <init>()>")) {
            this.result = new LanguageConstraints.Box(new LanguageConstraints.Terminal(""));
            return;
        }
        LanguageConstraints.Box[] arguments = this.evalArguments(v);
        this.result = this.getCaleeAndPutCallArguments(this.stmt, arguments);
    }

    @Override
    public void caseStaticInvokeExpr(StaticInvokeExpr v) {
        this.dbg("caseStaticInvokeExpr", v);
        if (this.hasSignature(v, "<java.lang.String: java.lang.String valueOf(java.lang.Object)>")) {
            this.result = this.evalArg(v, 0);
            return;
        }
        LanguageConstraints.Box[] arguments = this.evalArguments(v);
        this.result = this.getCaleeAndPutCallArguments(this.stmt, arguments);
    }

    @Override
    public void caseDynamicInvokeExpr(DynamicInvokeExpr v) {
        this.ignore("caseDynamicInvokeExpr", v);
    }

    @Override
    public void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
        this.dbg("caseVirtualInvokeExpr", v);
        if (this.hasSignature(v, "<java.lang.StringBuilder: java.lang.StringBuilder append(java.lang.String)>")) {
            LanguageConstraints.Box l = this.evalBase(v);
            LanguageConstraints.Box r = this.evalArg(v, 0);
            this.result = new LanguageConstraints.Box(new LanguageConstraints.Concatenate(l, r));
            return;
        }
        if (this.hasPrefixSignature(v, "<java.lang.StringBuilder: java.lang.StringBuilder append(")) {
            LanguageConstraints.Box l = this.evalBase(v);
            this.result = new LanguageConstraints.Box(new LanguageConstraints.Concatenate(l, LanguageConstraints.BottomBox()));
            return;
        }
        if (this.hasSignature(v, "<java.lang.StringBuilder: java.lang.String toString()>")) {
            this.result = this.evalBase(v);
            return;
        }
        LanguageConstraints.Box[] arguments = this.evalArguments(v);
        this.result = this.getCaleeAndPutCallArguments(this.stmt, arguments);
    }

    @Override
    public void caseCastExpr(CastExpr v) {
        this.ignore("caseCastExpr", v);
    }

    @Override
    public void caseInstanceOfExpr(InstanceOfExpr v) {
        this.ignore("caseInstanceOfExpr", v);
    }

    @Override
    public void caseNewArrayExpr(NewArrayExpr v) {
        this.result = new LanguageConstraints.Box(LanguageConstraints.Top.v());
    }

    @Override
    public void caseNewMultiArrayExpr(NewMultiArrayExpr v) {
        this.ignore("caseNewMultiArrayExpr", v);
    }

    @Override
    public void caseNewExpr(NewExpr v) {
        this.dbg("caseNewExpr", v);
        this.result = new LanguageConstraints.Box(LanguageConstraints.Top.v());
    }

    @Override
    public void caseLengthExpr(LengthExpr v) {
        this.ignore("caseLengthExpr", v);
    }

    @Override
    public void caseNegExpr(NegExpr v) {
        this.ignore("caseNegExpr", v);
    }

    @Override
    public void caseArrayRef(ArrayRef v) {
        this.dbg("caseArrayRef", v);
        Value base = v.getBase();
        this.result = this.eval(base);
    }

    @Override
    public void caseStaticFieldRef(StaticFieldRef v) {
        this.dbg("caseStaticFieldRef", v);
        this.result = Res2Constr.getField(v);
    }

    @Override
    public void caseInstanceFieldRef(InstanceFieldRef v) {
        this.ignore("caseInstanceFieldRef", v);
        this.result = Res2Constr.getField(v);
    }

    @Override
    public void caseParameterRef(ParameterRef v) {
        this.dbg("caseParameterRef", v);
        this.result = new LanguageConstraints.Box(new LanguageConstraints.Parameter(this.sm, v.getIndex()));
    }

    @Override
    public void caseCaughtExceptionRef(CaughtExceptionRef v) {
        this.ignore("caseCaughtExceptionRef", v);
    }

    @Override
    public void caseThisRef(ThisRef v) {
        this.ignore("caseThisRef", v);
    }

    @Override
    public void caseLocal(Local l) {
        this.dbg("caseLocal", l);
        this.result = this.svis.mergeDefsOfAt(l, this.stmt);
    }

    @Override
    public void defaultCase(Object o) {
        G.v().out.println("DBG:ccExprVisitor.defaultCase" + o + " class= " + o.getClass().getName());
    }

    @Override
    public void caseMethodHandle(MethodHandle handle) {
        throw new RuntimeException("MethodHandle not handled.");
    }
}

