/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.CCVisitor;
import edu.psu.cse.siis.coal.arguments.DBG;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.Res2Constr;
import java.util.List;
import soot.G;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.ParameterRef;
import soot.jimple.RefSwitch;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;

public class CCRefVisitor
implements RefSwitch {
    public static final boolean ARRAY_FIELDS = false;
    static int verbose_level = 0;
    LanguageConstraints.Box lcb;
    Stmt stmt;
    CCVisitor svis;

    public CCRefVisitor s(LanguageConstraints.Box lcb0, Stmt s) {
        this.lcb = lcb0;
        this.stmt = s;
        return this;
    }

    public CCRefVisitor(CCVisitor svis0) {
        this.svis = svis0;
    }

    protected void dbg0(String what, Value v) {
        G.v().out.println("DBG:CCRefVisitor." + what + " v=" + v + " class= " + v.getClass().getName() + " type= " + v.getType() + " type-class= " + v.getType().getClass().getName());
    }

    protected void ignore(String what, Value v) {
        if (verbose_level > 10) {
            this.dbg0(what, v);
        }
    }

    protected void dbg(String what, Value v) {
        if (verbose_level > 5) {
            this.dbg0(what, v);
        }
    }

    @Override
    public void caseArrayRef(ArrayRef v) {
        this.ignore("caseArrayRef", v);
        Value base = v.getBase();
        DBG.dbgValue("caseArrayRef's base", base);
        if (base instanceof Local) {
            Local l = (Local)base;
            List<Unit> bdefs = this.svis.mld.getDefsOfAt(l, this.stmt);
            for (Stmt stmt : bdefs) {
                stmt.apply(this.svis);
                LanguageConstraints.Box defb = Res2Constr.getStmt(stmt);
                assert (defb != null);
                LanguageConstraints.Union lcu = new LanguageConstraints.Union();
                lcu.addLCB(new LanguageConstraints.Box(defb.getLC()));
                lcu.addLCB(this.lcb);
                defb.setLC(lcu);
            }
        }
    }

    @Override
    public void caseStaticFieldRef(StaticFieldRef v) {
        this.dbg("caseStaticFieldRef", v);
        Res2Constr.putField(v, this.lcb);
    }

    @Override
    public void caseInstanceFieldRef(InstanceFieldRef v) {
        this.ignore("caseInstanceFieldRef", v);
        Res2Constr.putField(v, this.lcb);
    }

    @Override
    public void caseParameterRef(ParameterRef v) {
        this.ignore("caseParameterRef", v);
    }

    @Override
    public void caseCaughtExceptionRef(CaughtExceptionRef v) {
        this.ignore("caseCaughtExceptionRef", v);
    }

    @Override
    public void caseThisRef(ThisRef v) {
        this.ignore("caseThisRef", v);
    }

    @Override
    public void defaultCase(Object obj) {
        G.v().out.println("Ignore: CCRefVisitor.defaultCase obj=" + obj + " class= " + obj.getClass().getName());
    }
}

