/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.CCExprVisitor;
import edu.psu.cse.siis.coal.arguments.CCRefVisitor;
import edu.psu.cse.siis.coal.arguments.DBG;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.MySmartLocalDefs;
import edu.psu.cse.siis.coal.arguments.Res2Constr;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.G;
import soot.Local;
import soot.NullType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtSwitch;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

class CCVisitor
implements StmtSwitch {
    static int verbose_level = 0;
    MySmartLocalDefs mld;
    CCExprVisitor ccExprVisitor;
    ExceptionalUnitGraph graph;
    SootMethod sm;

    CCVisitor(ExceptionalUnitGraph graph0) {
        this.graph = graph0;
        this.sm = this.graph.getBody().getMethod();
        this.mld = new MySmartLocalDefs(this.graph);
        this.ccExprVisitor = new CCExprVisitor(this, this.sm);
    }

    protected void dbg(String what, Stmt s, Object ... args) {
        if (verbose_level > 10) {
            G.v().out.println("DBG:CCVisitor." + String.format(what, args) + " " + s + "  class= " + s.getClass().getName());
        }
    }

    protected void dbg(String what) {
        if (verbose_level > 10) {
            G.v().out.println("DBG:CCVisitor." + what);
        }
    }

    protected void ignore(String what, Stmt s) {
        this.dbg(what, s, new Object[0]);
    }

    LanguageConstraints.Box mergeDefsOfAt(Local l, Stmt stmt) {
        List<Unit> defs = this.mld.getDefsOfAt(l, stmt);
        assert (defs.size() > 0);
        ArrayList<LanguageConstraints.Box> lst = new ArrayList<LanguageConstraints.Box>();
        Iterator<Unit> rDefsIt = defs.iterator();
        HashSet<Stmt> sset = new HashSet<Stmt>();
        while (rDefsIt.hasNext()) {
            Stmt sdef = (Stmt)rDefsIt.next();
            assert (!sset.contains(sdef));
            sset.add(sdef);
            sdef.apply(this);
            LanguageConstraints.Box defb = Res2Constr.getStmt(sdef);
            assert (defb != null);
            lst.add(defb);
        }
        LanguageConstraints.Box lcb = LanguageConstraints.Box.mergeListLCB(lst);
        assert (lcb != null);
        return lcb;
    }

    int countDefsOfAt(Local l, Stmt stmt) {
        int res = this.mld.getDefsOfAt(l, stmt).size();
        assert (res > 0);
        return res;
    }

    static boolean isStringLike(Value v) {
        Type type = v.getType();
        String type_name = type.toString();
        return type_name.equals("java.lang.String") || type_name.equals("java.lang.StringBuilder") || type_name.equals("java.lang.String[]") || type instanceof NullType || MySmartLocalDefs.isSpecialInvokeHack(v);
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
        this.ignore("caseBreakpointStmt", stmt);
    }

    @Override
    public void caseInvokeStmt(InvokeStmt iStmt) {
        this.dbg("caseInvokeStmt", iStmt, new Object[0]);
        if (Res2Constr.checkAndSetProcessedStmt(iStmt)) {
            return;
        }
        if (!(CCVisitor.isStringLike(iStmt.getInvokeExpr()) || MySmartLocalDefs.hasStringParameters(iStmt.getInvokeExpr()) || MySmartLocalDefs.hasStringSideEffectHack(iStmt.getInvokeExpr()))) {
            return;
        }
        LanguageConstraints.Box iexpr_lcb = this.ccExprVisitor.eval(iStmt.getInvokeExpr(), iStmt);
        Res2Constr.putStmt(iStmt, iexpr_lcb);
        if (MySmartLocalDefs.hasStringSideEffectHack(iStmt.getInvokeExpr())) {
            AbstractInstanceInvokeExpr iexpr = (AbstractInstanceInvokeExpr)iStmt.getInvokeExpr();
            Value base = iexpr.getBase();
            DBG.dbgDefsOfAt(base, iStmt, this.graph);
            SmartLocalDefs sld = new SmartLocalDefs(this.graph, new SimpleLiveLocals(this.graph));
            assert (base instanceof Local);
            Local l = (Local)base;
            List<Unit> defs = sld.getDefsOfAt(l, iStmt);
            assert (defs.size() == 1);
            Stmt sdef = (Stmt)defs.get(0);
            Res2Constr.putStmt(sdef, iexpr_lcb);
        }
    }

    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        if (Res2Constr.checkAndSetProcessedStmt(stmt)) {
            return;
        }
        Value lop = stmt.getLeftOp();
        Value rop = stmt.getRightOp();
        if (!CCVisitor.isStringLike(lop) && !MySmartLocalDefs.hasStringParameters(rop)) {
            Res2Constr.putStmtBottom(stmt);
            return;
        }
        this.dbg("caseAssignStmt", stmt, new Object[0]);
        DBG.dbgValue("DBG:caseAssignStmt's lop:", lop);
        assert (!(rop instanceof IdentityRef));
        LanguageConstraints.Box rop_lcb = this.ccExprVisitor.eval(rop, stmt);
        Res2Constr.putStmt(stmt, rop_lcb);
        if (lop instanceof Ref) {
            LanguageConstraints.Box lcb = Res2Constr.getStmt(stmt);
            CCRefVisitor ccrv = new CCRefVisitor(this);
            lop.apply(ccrv.s(lcb, stmt));
        }
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
        this.dbg("caseIdentityStmt", stmt, new Object[0]);
        if (Res2Constr.checkAndSetProcessedStmt(stmt)) {
            return;
        }
        Value rop = stmt.getRightOp();
        assert (rop instanceof IdentityRef);
        if (!(rop instanceof ThisRef || rop instanceof ParameterRef || rop instanceof CaughtExceptionRef)) {
            G.v().out.println("should throw new RuntimeException(\"Unexpected right operand kind!\")");
        }
        LanguageConstraints.Box rop_lcb = this.ccExprVisitor.eval(rop, stmt);
        Res2Constr.putStmt(stmt, rop_lcb);
        this.dbg("caseIdentityStmt:rop %s class= %s", stmt, rop, rop.getClass().getName());
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        this.ignore("caseEnterMonitorStmt", stmt);
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        this.ignore("caseExitMonitorStmt", stmt);
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
        this.ignore("caseGotoStmt", stmt);
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        this.ignore("caseIfStmt", stmt);
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        this.ignore("caseLookupSwitchStmt", stmt);
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
        this.ignore("caseNopStmt", stmt);
    }

    @Override
    public void caseRetStmt(RetStmt stmt) {
        this.ignore("caseRetStmt", stmt);
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        this.ignore("caseReturnStmt", stmt);
        Value rop = stmt.getOp();
        LanguageConstraints.Box rop_lcb = this.ccExprVisitor.eval(rop, stmt);
        Res2Constr.putReturn(this.sm, stmt, rop_lcb);
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
        this.ignore("caseReturnVoidStmt", stmt);
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        this.ignore("caseTableSwitchStmt", stmt);
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
        this.ignore("caseThrowStmt", stmt);
    }

    @Override
    public void defaultCase(Object obj) {
        throw new RuntimeException("Unknown Stmt!");
    }
}

