/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.arguments.ArgumentValueManager;
import edu.psu.cse.siis.coal.arguments.BackwardValueAnalysis;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.ClassConstant;
import soot.jimple.DefinitionStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.scalar.Pair;

public class ClassValueAnalysis
extends BackwardValueAnalysis {
    private static final String TOP_VALUE = "(.*)";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Set<Object> computeInlineArgumentValues(String[] inlineValues) {
        return new HashSet<Object>(Arrays.asList(inlineValues));
    }

    @Override
    public Set<Object> computeVariableValues(Value value, Stmt start) {
        if (value instanceof ClassConstant) {
            return Collections.singleton(((ClassConstant)value).getValue());
        }
        if (value instanceof Local) {
            return this.processClassAssignments(this.findAssignmentsForLocal(start, (Local)value, true, new HashSet<Pair<Unit, Local>>()), new HashSet<Stmt>());
        }
        return Collections.singleton(TOP_VALUE);
    }

    private Set<Object> processClassAssignments(List<DefinitionStmt> assignStmts, Set<Stmt> visitedStmts) {
        HashSet<Object> result = new HashSet<Object>(assignStmts.size());
        for (DefinitionStmt assignStmt : assignStmts) {
            Value rhsValue = assignStmt.getRightOp();
            if (rhsValue instanceof ClassConstant) {
                result.add(((ClassConstant)rhsValue).getValue().intern());
                continue;
            }
            if (rhsValue instanceof ParameterRef) {
                ParameterRef parameterRef = (ParameterRef)rhsValue;
                Iterator<Edge> edges = Scene.v().getCallGraph().edgesInto(AnalysisParameters.v().getIcfg().getMethodOf(assignStmt));
                while (edges.hasNext()) {
                    Edge edge = edges.next();
                    InvokeExpr invokeExpr = edge.srcStmt().getInvokeExpr();
                    Set<Object> newResults = this.computeVariableValues(invokeExpr.getArg(parameterRef.getIndex()), edge.srcStmt());
                    if (newResults.contains(TOP_VALUE) || newResults.contains(TOP_VALUE)) {
                        return Collections.singleton(TOP_VALUE);
                    }
                    result.addAll(newResults);
                }
                continue;
            }
            if (rhsValue instanceof InvokeExpr) {
                InvokeExpr invokeExpr = (InvokeExpr)rhsValue;
                SootMethod method = invokeExpr.getMethod();
                if (method.getSignature().equals("<java.lang.Class: java.lang.Class forName(java.lang.String)>") || method.getSignature().equals("<java.lang.ClassLoader: java.lang.Class loadClass(java.lang.String)>")) {
                    Set<Object> classNames = ArgumentValueManager.v().getArgumentValueAnalysis("String").computeVariableValues(invokeExpr.getArg(0), assignStmt);
                    if (classNames.contains(TOP_VALUE)) {
                        return Collections.singleton(TOP_VALUE);
                    }
                    result.addAll(classNames);
                    continue;
                }
                if (method.getSignature().equals("<java.lang.Object: java.lang.Class getClass()>")) {
                    VirtualInvokeExpr virtualInvokeExpr = (VirtualInvokeExpr)invokeExpr;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Returning " + virtualInvokeExpr.getBase().getType().toString());
                    }
                    return Collections.singleton(virtualInvokeExpr.getBase().getType().toString());
                }
                Set<Object> constantClasses = this.handleInvokeExpression(assignStmt, visitedStmts);
                if (constantClasses == null) {
                    return Collections.singleton(TOP_VALUE);
                }
                result.addAll(constantClasses);
                continue;
            }
            return Collections.singleton(TOP_VALUE);
        }
        if (result.size() == 0) {
            return Collections.singleton(TOP_VALUE);
        }
        return result;
    }

    protected Set<Object> handleInvokeExpression(Stmt sourceStmt, Set<Stmt> visitedStmts) {
        if (visitedStmts.contains(sourceStmt)) {
            return Collections.emptySet();
        }
        visitedStmts.add(sourceStmt);
        Iterator<Edge> edges = Scene.v().getCallGraph().edgesOutOf(sourceStmt);
        HashSet<Object> result = new HashSet<Object>();
        while (edges.hasNext()) {
            Edge edge = edges.next();
            SootMethod target = edge.getTgt().method();
            if (!target.isConcrete()) continue;
            for (Unit unit : target.getActiveBody().getUnits()) {
                if (!(unit instanceof ReturnStmt)) continue;
                ReturnStmt returnStmt = (ReturnStmt)unit;
                Value returnValue = returnStmt.getOp();
                if (returnValue instanceof StringConstant) {
                    result.add(((StringConstant)returnValue).value);
                    continue;
                }
                if (returnValue instanceof ClassConstant) {
                    result.add(((ClassConstant)returnValue).value);
                    continue;
                }
                if (returnValue instanceof Local) {
                    List<DefinitionStmt> assignStmts = this.findAssignmentsForLocal(returnStmt, (Local)returnValue, true, new HashSet<Pair<Unit, Local>>());
                    Set<Object> classConstants = this.processClassAssignments(assignStmts, visitedStmts);
                    if (classConstants == null || classConstants.contains(TOP_VALUE) || classConstants.contains(TOP_VALUE)) {
                        return null;
                    }
                    result.addAll(classConstants);
                    continue;
                }
                return null;
            }
        }
        return result;
    }

    @Override
    public Object getTopValue() {
        return TOP_VALUE;
    }
}

