/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.AliasAdjuster;
import edu.psu.cse.siis.coal.arguments.CCVisitor;
import edu.psu.cse.siis.coal.arguments.DBG;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.Res2Constr;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import soot.Body;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.util.queue.QueueReader;

public class ConstraintCollector {
    CCVisitor cc_svis;
    private boolean done_methodCollection = false;
    ExceptionalUnitGraph graph;
    private static boolean done_globalCollection = false;

    public ConstraintCollector(ExceptionalUnitGraph exceptionalUnitGraph) {
        this.graph = exceptionalUnitGraph;
        this.cc_svis = new CCVisitor(this.graph);
    }

    LanguageConstraints.Box getConstraintOfAt(Local l, Stmt stmt) {
        if (!this.done_methodCollection && !done_globalCollection) {
            ConstraintCollector.handleMethod(this.graph.getBody().getMethod());
            this.done_methodCollection = true;
        }
        return this.cc_svis.mergeDefsOfAt(l, stmt);
    }

    LanguageConstraints.Box getConstraintOfValueAt(Value v, Stmt stmt) {
        if (v instanceof Local) {
            return this.getConstraintOfAt((Local)v, stmt);
        }
        if (v instanceof StringConstant) {
            return new LanguageConstraints.Box(new LanguageConstraints.Terminal(((StringConstant)v).value));
        }
        return null;
    }

    static void handleMethod(SootMethod method) {
        Body body = method.getActiveBody();
        AliasAdjuster.changeBody(body);
        ExceptionalUnitGraph cfg = new ExceptionalUnitGraph(body);
        CCVisitor method_svis = new CCVisitor(cfg);
        Stack<Unit> stack = new Stack<Unit>();
        for (Unit unit : cfg.getHeads()) {
            stack.push(unit);
        }
        HashSet<Unit> visited = new HashSet<Unit>();
        while (!stack.empty()) {
            Unit unit = (Unit)stack.pop();
            if (visited.contains(unit)) continue;
            visited.add(unit);
            Stmt s = (Stmt)unit;
            DBG.dbgStmt(s, "......... looking", new Object[0]);
            s.apply(method_svis);
            DBG.dbgStmt(s, "DONE looking and got lcb-for-s: %s", Res2Constr.getStmt(s));
            for (Unit successor : cfg.getSuccsOf(unit)) {
                stack.push(successor);
            }
        }
    }

    static void globalCollection(ModelInterface ccModel) {
        if (done_globalCollection) {
            return;
        }
        done_globalCollection = true;
        ArrayList<SootMethod> eps = new ArrayList<SootMethod>(Scene.v().getEntryPoints());
        ReachableMethods reachableMethods = new ReachableMethods(Scene.v().getCallGraph(), eps.iterator(), null);
        reachableMethods.update();
        QueueReader<MethodOrMethodContext> iter = reachableMethods.listener();
        while (iter.hasNext()) {
            SootMethod method = ((MethodOrMethodContext)iter.next()).method();
            if (!method.hasActiveBody() || ccModel.isExcludedClass(method.getDeclaringClass().getName())) continue;
            ConstraintCollector.handleMethod(method);
        }
    }

    public static class CCModelInterface
    implements ModelInterface {
        @Override
        public boolean isExcludedClass(String class_name) {
            return class_name.startsWith("sun.") || class_name.startsWith("java.") || class_name.startsWith("com.") || class_name.startsWith("org.");
        }
    }

    public static interface ModelInterface {
        public boolean isExcludedClass(String var1);
    }
}

