/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.DBGExprVisitor;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.RecursiveDAGSolverVisitorLC;
import edu.psu.cse.siis.coal.arguments.Res2Constr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

public class DBG {
    static int verbose_level = 0;

    public static void dbgEdgesOutOf(Unit u) {
        CallGraph cg = Scene.v().getCallGraph();
        Iterator<Edge> it = cg.edgesOutOf(u);
        while (it.hasNext()) {
            Edge e = it.next();
            SootMethod tgt = e.tgt();
            G.v().out.println("tgt:" + tgt);
            G.v().out.println("edge:" + e);
        }
    }

    static void imprecise(String msg) {
        if (verbose_level > 100) {
            G.v().out.println("IMPRECISION:" + msg);
        }
    }

    public static void dbgValue(String msg, Value v) {
        if (verbose_level > 10) {
            G.v().out.print("DBG:Value:" + msg + ":");
            v.apply(new DBGExprVisitor());
        }
    }

    public static void print(String what, Object ... args) {
        if (verbose_level > 10) {
            G.v().out.println(String.format(what, args));
        }
    }

    public static void dbgfIELD(StaticFieldRef sfr) {
    }

    public static void dbgUses(Value v) {
        Iterator<ValueBox> it = v.getUseBoxes().iterator();
        while (it.hasNext()) {
            Value o = it.next().getValue();
            DBG.dbgValue("USE:", o);
        }
    }

    public static void dbgStmt(Stmt s, String msg, Object ... args) {
        if (verbose_level > 10) {
            G.v().out.println("dbgStmt:" + String.format(msg, args) + " at stmt: " + s + " of type " + s.getClass().getName());
        }
    }

    public static void dbgFieldMap() {
        Map<String, LanguageConstraints.Box> fmap = Res2Constr.get_field2constr();
        TreeSet<String> keys = new TreeSet<String>(fmap.keySet());
        for (String key : keys) {
            LanguageConstraints.Box lcb = fmap.get(key);
            DBG.showLCB(lcb, "field-" + key);
        }
    }

    static void showLCB(LanguageConstraints.Box lcb, String msg) {
        if (verbose_level < 5) {
            return;
        }
        G.v().out.println("RESULT-lcb:[" + msg + "]\t=======>\t" + lcb);
        RecursiveDAGSolverVisitorLC dagvlc = new RecursiveDAGSolverVisitorLC(5);
        if (dagvlc.solve(lcb)) {
            ArrayList<Object> list = new ArrayList<Object>(dagvlc.result);
            G.v().out.print("RESULT-set:[" + msg + "]\t=======>\t{");
            for (Object lstr : list) {
                G.v().out.print("\"" + lstr + "\"; ");
            }
            G.v().out.println("}");
        }
    }

    public static void BUG(String msg) {
        G.v().out.println("KNOWN-BUG:" + msg);
    }

    static void dbgDefsOfAt(Value v, Stmt stmt, ExceptionalUnitGraph graph) {
        if (verbose_level <= 10) {
            return;
        }
        SmartLocalDefs sld = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        if (!(v instanceof Local)) {
            DBG.dbgValue("not a local", v);
        }
        Local l = (Local)v;
        G.v().out.println("dbgDefsOf v=" + v + " at " + stmt + ">>>>>>>>>>>>>>");
        List<Unit> defs = sld.getDefsOfAt(l, stmt);
        for (Stmt stmt2 : defs) {
            DBG.dbgStmt(stmt2, "definition:", new Object[0]);
        }
        G.v().out.println("<<<<<<<<<<<<<<");
    }
}

