/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.CCExprVisitor;
import edu.psu.cse.siis.coal.arguments.CCVisitor;
import edu.psu.cse.siis.coal.arguments.ConstraintCollector;
import edu.psu.cse.siis.coal.arguments.DBG;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.RecursiveDAGSolverVisitorLC;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.Local;
import soot.Main;
import soot.PackManager;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Unit;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;

class ExampleStringAnalyzer
extends SceneTransformer {
    private static final boolean USE_SHIMPLE = false;
    static boolean dbg_hack_force = false;
    static boolean dbg_hack = false;

    ExampleStringAnalyzer() {
    }

    public static void main(String[] args) {
        G.v().out.println("in ExampleStringAnalyzer.main");
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().setPhaseOption("jb.ulp", "off");
        Options.v().setPhaseOption("jb.uce", "remove-unreachable-traps:true");
        String pack = "wjtp";
        PackManager.v().getPack(pack).add(new Transform(String.valueOf(pack) + ".ExampleStringAnalyzer", new ExampleStringAnalyzer()));
        CCExprVisitor.verbose_level = 20;
        CCVisitor.verbose_level = 20;
        DBG.verbose_level = 20;
        Main.main(args);
    }

    protected void internalTransform(String phase, Map options) {
        boolean want_global_analysis = true;
        if (want_global_analysis) {
            ConstraintCollector.globalCollection(new ConstraintCollector.CCModelInterface(){

                @Override
                public boolean isExcludedClass(String class_name) {
                    return class_name.startsWith("sun.") || class_name.startsWith("java.") || class_name.startsWith("com.") || class_name.startsWith("org.");
                }
            });
        }
        for (SootClass sootClass : Scene.v().getApplicationClasses()) {
            for (SootMethod method : sootClass.getMethods()) {
                G.v().out.println("DBG:SEEN:" + method);
            }
        }
        for (SootClass sootClass : Scene.v().getApplicationClasses()) {
            for (SootMethod method : sootClass.getMethods()) {
                ConstraintCollector cc = new ConstraintCollector(new ExceptionalUnitGraph(method.retrieveActiveBody()));
                Iterator<Unit> unitIt = method.getActiveBody().getUnits().snapshotIterator();
                G.v().out.println("DO internalTransform for " + method);
                G.v().out.println("BODY " + method.getActiveBody());
                while (unitIt.hasNext()) {
                    Unit s = unitIt.next();
                    ExampleStringAnalyzer.handleStatement(s, cc, method);
                }
            }
        }
    }

    static void handleStatement(Unit u, ConstraintCollector cc, SootMethod method) {
        Value v;
        Stmt s = (Stmt)u;
        if (!s.containsInvokeExpr()) {
            return;
        }
        InvokeExpr iexpr = s.getInvokeExpr();
        SootMethod sm = iexpr.getMethod();
        String m_signature = sm.getSignature();
        if (m_signature.equals("<java.io.PrintStream: void println(java.lang.String)>") && (v = iexpr.getArg(0)) instanceof Local) {
            String str_lcb;
            RecursiveDAGSolverVisitorLC dagvlc = new RecursiveDAGSolverVisitorLC(5);
            Local l = (Local)v;
            LanguageConstraints.Box lcb = cc.getConstraintOfAt(l, s);
            if (dagvlc.solve(lcb)) {
                G.v().out.println("DAG-VISITOR:RES:\t\t=======>\t\t" + dagvlc.result);
                if (dbg_hack_force && dbg_hack && dagvlc.result.isEmpty()) {
                    G.v().out.println("EMPTY");
                    dagvlc.solve(lcb);
                    str_lcb = lcb.toString();
                    G.v().out.println("DAG-VISITOR:lcb:\t\t=======>\t\t" + str_lcb);
                }
            }
            str_lcb = lcb.toString();
            G.v().out.println("DAG-VISITOR:lcb:\t\t=======>\t\t" + str_lcb);
        }
    }

    static void p2dbg(SootMethod method) {
        Iterator<Local> localsIt = method.getActiveBody().getLocals().iterator();
        G.v().out.println(">>>>>> p2 locals of" + method);
        while (localsIt.hasNext()) {
            Local l = localsIt.next();
            ExampleStringAnalyzer.p2dbg(l, method);
        }
        G.v().out.println("<<<<<< p2 locals of" + method);
    }

    static void p2dbg(Value v, SootMethod current_sm) {
        if (v instanceof Local) {
            Local l = (Local)v;
            PointsToAnalysis pta = Scene.v().getPointsToAnalysis();
            PointsToSet set = pta.reachingObjects(l);
            Set<String> strConstants = set.possibleStringConstants();
            G.v().out.println(strConstants);
            G.v().out.println("PossibleTypes:" + set.possibleTypes());
            for (Local l2 : current_sm.getActiveBody().getLocals()) {
                PointsToSet set2 = Scene.v().getPointsToAnalysis().reachingObjects(l2);
                if (!set.hasNonEmptyIntersection(set2)) continue;
                G.v().out.println(l + "<-->" + l2);
                Set<String> strConstants2 = set2.possibleStringConstants();
                G.v().out.println(strConstants2);
            }
        }
    }
}

