/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.ConstraintCollector;
import edu.psu.cse.siis.coal.arguments.DAGSolverVisitorLC;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.ToStringVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Main;
import soot.PackManager;
import soot.SootMethod;
import soot.Transform;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.shimple.ShimpleBody;
import soot.toolkits.graph.ExceptionalUnitGraph;

public class GlobalTester
extends BodyTransformer {
    public static void main(String[] args) {
        G.v().out.println("in Tester.main");
        PackManager.v().getPack("jtp").add(new Transform("jtp.Tester", new GlobalTester()));
        ToStringVisitor.show_uid = false;
        Main.main(args);
    }

    protected void internalTransform(Body body, String phase, Map options) {
        assert (!(body instanceof ShimpleBody));
        SootMethod sm = body.getMethod();
        G.v().out.println("Tester for:" + sm);
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body);
        ConstraintCollector cc = new ConstraintCollector(graph);
        Iterator<Unit> unitIt = body.getUnits().snapshotIterator();
        G.v().out.println("in ConstraintCollector for " + body.getMethod());
        while (unitIt.hasNext()) {
            Unit s = unitIt.next();
            GlobalTester.handleStatement(s, cc, sm);
        }
    }

    static void handleStatement(Unit u, ConstraintCollector cc, SootMethod current_sm) {
        Stmt s = (Stmt)u;
        if (s.containsInvokeExpr()) {
            InvokeExpr iexpr = s.getInvokeExpr();
            SootMethod sm = iexpr.getMethod();
            String m_signature = sm.getSignature();
            if (m_signature.equals("<java.io.PrintStream: void println(java.lang.String)>")) {
                Value v = iexpr.getArg(0);
                GlobalTester.handleValue(v, s, cc, current_sm, "arg0:");
            }
        } else if (s instanceof ReturnStmt) {
            ReturnStmt rs = (ReturnStmt)s;
            ValueBox vb = rs.getOpBox();
            Value v = vb.getValue();
            GlobalTester.handleValue(v, s, cc, current_sm, "ret:");
        }
    }

    static void handleValue(Value v, Stmt s, ConstraintCollector cc, SootMethod current_sm, String msg) {
        LanguageConstraints.Box lcb = cc.getConstraintOfValueAt(v, s);
        G.v().out.println("RESULT-lcb:[" + msg + current_sm.getName() + "]\t=======>\t" + lcb);
        DAGSolverVisitorLC dagvlc = new DAGSolverVisitorLC();
        if (dagvlc.solve(lcb)) {
            ArrayList<String> list = new ArrayList<String>(dagvlc.result);
            Collections.sort(list);
            G.v().out.print("RESULT-set:[" + msg + current_sm.getName() + "]\t=======>\t{");
            for (String lstr : list) {
                G.v().out.print("\"" + lstr + "\"; ");
            }
            G.v().out.println("}");
        }
    }
}

