/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.AnalysisParameters;
import edu.psu.cse.siis.coal.arguments.BackwardValueAnalysis;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import soot.Local;
import soot.Scene;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.LongConstant;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.scalar.Pair;

public class IntValueAnalysis
extends BackwardValueAnalysis {
    private static final int TOP_VALUE = -1;

    @Override
    public Set<Object> computeInlineArgumentValues(String[] inlineValues) {
        HashSet<Object> result = new HashSet<Object>(inlineValues.length);
        for (String intString : inlineValues) {
            result.add(Integer.parseInt(intString));
        }
        return result;
    }

    @Override
    public Set<Object> computeVariableValues(Value value, Stmt start) {
        if (value instanceof IntConstant) {
            return Collections.singleton(((IntConstant)value).value);
        }
        if (value instanceof LongConstant) {
            return Collections.singleton(((LongConstant)value).value);
        }
        if (value instanceof Local) {
            return this.findIntAssignmentsForLocal(start, (Local)value, new HashSet<Stmt>());
        }
        return Collections.singleton(-1);
    }

    private Set<Object> findIntAssignmentsForLocal(Stmt start, Local local, Set<Stmt> visitedStmts) {
        List<DefinitionStmt> assignStmts = this.findAssignmentsForLocal(start, local, true, new HashSet<Pair<Unit, Local>>());
        HashSet<Object> result = new HashSet<Object>(assignStmts.size());
        for (DefinitionStmt assignStmt : assignStmts) {
            Value rhsValue = assignStmt.getRightOp();
            if (rhsValue instanceof IntConstant) {
                result.add(((IntConstant)rhsValue).value);
                continue;
            }
            if (rhsValue instanceof LongConstant) {
                result.add(((LongConstant)rhsValue).value);
                continue;
            }
            if (rhsValue instanceof ParameterRef) {
                ParameterRef parameterRef = (ParameterRef)rhsValue;
                Iterator<Edge> edges = Scene.v().getCallGraph().edgesInto(AnalysisParameters.v().getIcfg().getMethodOf(assignStmt));
                while (edges.hasNext()) {
                    Edge edge = edges.next();
                    InvokeExpr invokeExpr = edge.srcStmt().getInvokeExpr();
                    Value argValue = invokeExpr.getArg(parameterRef.getIndex());
                    if (argValue instanceof IntConstant) {
                        result.add(((IntConstant)argValue).value);
                        continue;
                    }
                    if (argValue instanceof LongConstant) {
                        result.add(((LongConstant)argValue).value);
                        continue;
                    }
                    if (argValue instanceof Local) {
                        Set<Object> newResults = this.findIntAssignmentsForLocal(edge.srcStmt(), (Local)argValue, visitedStmts);
                        result.addAll(newResults);
                        continue;
                    }
                    result.add(-1);
                }
                continue;
            }
            return Collections.singleton(-1);
        }
        return result;
    }

    @Override
    public Object getTopValue() {
        return -1;
    }
}

