/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.RecursiveDAGSolverVisitorLC;
import edu.psu.cse.siis.coal.arguments.ToStringVisitor;
import edu.psu.cse.siis.coal.arguments.switchLC;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.Stmt;

public abstract class LanguageConstraints {
    static int g_uid = 0;
    public final int uid = ++g_uid;
    private static Box bottomBox = null;

    public String toString() {
        ToStringVisitor tsv = new ToStringVisitor();
        this.apply(tsv);
        return tsv.result.toString();
    }

    public String toString(Set<LanguageConstraints> seen) {
        ToStringVisitor tsv = new ToStringVisitor(seen);
        this.apply(tsv);
        return tsv.result.toString();
    }

    public abstract void apply(switchLC var1);

    public static Box BottomBox() {
        if (bottomBox == null) {
            bottomBox = new Box(Bottom.v());
        }
        return bottomBox;
    }

    public static Box NullConstantBox() {
        return new Box(new Terminal("NULL-CONSTANT"));
    }

    public static final class Bottom
    extends LanguageConstraints {
        private static final Bottom bottom = new Bottom();

        public static LanguageConstraints v() {
            return bottom;
        }

        @Override
        public void apply(switchLC slc) {
            slc.caseBottom(this);
        }
    }

    public static class Box {
        static int g_uid = 0;
        int uid = ++g_uid;
        LanguageConstraints lc;
        static boolean show_uid = false;

        public Box() {
            this.lc = null;
        }

        public Box(LanguageConstraints lc0) {
            this.lc = lc0;
        }

        public void setLC(LanguageConstraints lc0) {
            this.lc = lc0;
        }

        public LanguageConstraints getLC() {
            return this.lc;
        }

        public String toString() {
            String lcstr;
            String string = lcstr = this.lc == null ? "{NULL}" : this.lc.toString();
            if (show_uid) {
                return "[" + this.uid + "]" + lcstr;
            }
            return lcstr;
        }

        public String toString(Set<LanguageConstraints> seen) {
            String lcstr;
            String string = lcstr = this.lc == null ? "{NULL}" : this.lc.toString(seen);
            if (show_uid) {
                return "[" + this.uid + "]" + lcstr;
            }
            return lcstr;
        }

        public void apply(switchLC slc) {
            if (this.lc != null) {
                this.lc.apply(slc);
            }
        }

        static Box mergeListLCB(List<Box> lst) {
            if (lst.size() == 1) {
                return lst.get(0);
            }
            Union lcu = new Union();
            for (Box lcb : lst) {
                lcu.addLCB(lcb);
            }
            Box res = new Box(lcu);
            return res;
        }
    }

    public static final class Call
    extends LanguageConstraints {
        SootMethod sm_context;
        public Stmt stmt;
        Box[] arguments;

        public Call(SootMethod sm0, Stmt stmt0, Box[] arguments0) {
            this.sm_context = sm0;
            this.stmt = stmt0;
            this.arguments = arguments0;
        }

        SootMethod callee() {
            return this.stmt.getInvokeExpr().getMethod();
        }

        @Override
        public void apply(switchLC slc) {
            slc.caseCall(this);
        }
    }

    public static class Concatenate
    extends LanguageConstraints {
        public Box left;
        public Box right;

        public Concatenate(Box l, Box r) {
            this.left = l;
            this.right = r;
        }

        @Override
        public void apply(switchLC slc) {
            slc.caseConcatenate(this);
        }
    }

    public static class Eq
    extends LanguageConstraints {
        public Box lcb;

        Eq(Box lcb0) {
            this.lcb = lcb0;
        }

        void setLCB(Box lcb0) {
            this.lcb = lcb0;
        }

        Box getLCB() {
            return this.lcb;
        }

        @Override
        public void apply(switchLC slc) {
            slc.caseEq(this);
        }
    }

    public static class FieldBox
    extends Box {
        @Override
        public void apply(switchLC slc) {
            boolean old_mode = slc.setFieldMode(true);
            if (this.lc != null) {
                this.lc.apply(slc);
            } else if (slc instanceof RecursiveDAGSolverVisitorLC) {
                Box tmpNullBox = LanguageConstraints.NullConstantBox();
                tmpNullBox.apply(slc);
            }
            slc.setFieldMode(old_mode);
        }
    }

    public static final class Parameter
    extends LanguageConstraints {
        SootMethod sm;
        public final int paramNum;

        public Parameter(SootMethod sm0, int paramNum0) {
            this.sm = sm0;
            this.paramNum = paramNum0;
        }

        @Override
        public void apply(switchLC slc) {
            slc.caseParameter(this);
        }
    }

    public static final class Pending
    extends LanguageConstraints {
        private static final Pending pending = new Pending();

        public static LanguageConstraints v() {
            return pending;
        }

        @Override
        public void apply(switchLC slc) {
            slc.casePending(this);
        }
    }

    public static final class Terminal
    extends LanguageConstraints {
        public final String term;

        public Terminal(String t) {
            this.term = t;
        }

        @Override
        public void apply(switchLC slc) {
            slc.caseTerminal(this);
        }
    }

    public static final class Top
    extends LanguageConstraints {
        private static final Top top = new Top();

        private Top() {
        }

        public static LanguageConstraints v() {
            return top;
        }

        @Override
        public void apply(switchLC slc) {
            slc.caseTop(this);
        }
    }

    public static class Union
    extends LanguageConstraints {
        public List<Box> elements = new ArrayList<Box>();

        void addLCB(Box elm) {
            this.elements.add(elm);
        }

        List<Box> getElementBoxes() {
            return this.elements;
        }

        @Override
        public void apply(switchLC slc) {
            slc.caseUnion(this);
        }
    }
}

