/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.G;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.toolkits.graph.DominatorsFinder;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.SimpleDominatorsFinder;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

public class LocalDefUse {
    private final Map<Local, Set<Unit>> l2def = new HashMap<Local, Set<Unit>>();
    private final Map<Local, Set<Unit>> l2use = new HashMap<Local, Set<Unit>>();
    private SootMethod sm;
    Body body;
    ExceptionalUnitGraph graph;
    SmartLocalDefs sld;
    DominatorsFinder dFinder;
    LocalDefUse ldu;

    void add(Map<Local, Set<Unit>> l2x, Local l, Unit stmt) {
        if (!l2x.containsKey(l)) {
            l2x.put(l, new HashSet());
        }
        Set<Unit> _set = l2x.get(l);
        _set.add(stmt);
    }

    void remove(Map<Local, Set<Unit>> l2x, Local l, Unit stmt) {
        if (l2x.containsKey(l)) {
            Set<Unit> _set = l2x.get(l);
            _set.remove(stmt);
        }
    }

    void add_facts(List<ValueBox> lst, Map<Local, Set<Unit>> l2x, Unit stmt) {
        Iterator<ValueBox> it = lst.iterator();
        while (it.hasNext()) {
            Value v = it.next().getValue();
            if (!(v instanceof Local)) continue;
            this.add(l2x, (Local)v, stmt);
        }
    }

    void remove_facts(List<ValueBox> lst, Map<Local, Set<Unit>> l2x, Unit stmt) {
        Iterator<ValueBox> it = lst.iterator();
        while (it.hasNext()) {
            Value v = it.next().getValue();
            if (!(v instanceof Local)) continue;
            this.remove(l2x, (Local)v, stmt);
        }
    }

    void recordUnit(Unit stmt) {
        List<ValueBox> uselst = stmt.getUseBoxes();
        List<ValueBox> deflst = stmt.getDefBoxes();
        this.add_facts(deflst, this.l2def, stmt);
        this.add_facts(uselst, this.l2use, stmt);
    }

    void deleteUnit(Unit stmt) {
        List<ValueBox> uselst = stmt.getUseBoxes();
        List<ValueBox> deflst = stmt.getDefBoxes();
        this.remove_facts(deflst, this.l2def, stmt);
        this.remove_facts(uselst, this.l2use, stmt);
    }

    LocalDefUse(Body body) {
        this.body = body;
        this.graph = new ExceptionalUnitGraph(body);
        if (this.graph.getHeads().size() != 1) {
            body.getUnits().addFirst(Jimple.v().newNopStmt());
            this.graph = new ExceptionalUnitGraph(body);
        }
        this.sld = new SmartLocalDefs(this.graph, new SimpleLiveLocals(this.graph));
        this.dFinder = new SimpleDominatorsFinder<Unit>(this.graph);
        Iterator<Unit> unitIt = this.body.getUnits().snapshotIterator();
        while (unitIt.hasNext()) {
            Unit stmt = unitIt.next();
            this.recordUnit(stmt);
        }
    }

    Set<Unit> getDefs(Local l) {
        return this.l2def.get(l);
    }

    Set<Unit> getUses(Local l) {
        return this.l2use.get(l);
    }

    void dbg(Value v, String msg) {
        if (v instanceof Local) {
            Local l = (Local)v;
            G.v().out.println(String.valueOf(msg) + ":USES:" + this.getUses(l));
            G.v().out.println(String.valueOf(msg) + ":DEFS:" + this.getDefs(l));
        }
    }

    boolean shouldMergeResultAndBase(Local res, Local base, Stmt stmt) {
        if (res == base) {
            return false;
        }
        Set<Unit> usesBase = this.getUses(base);
        return usesBase.size() != 1;
    }

    boolean canReplaceResult(Local oldRes, Local newRes, Stmt stmt) {
        Set<Unit> usesOld = this.getUses(oldRes);
        Set<Unit> defsOld = this.getDefs(oldRes);
        Set<Unit> defsNew = this.getDefs(newRes);
        if (defsOld.size() == 1) {
            return true;
        }
        for (Unit use : usesOld) {
            List<Unit> defsOldAtStmt = this.sld.getDefsOfAt(oldRes, use);
            if (defsOldAtStmt.size() <= 1) continue;
            return false;
        }
        return true;
    }

    boolean replaceResultAndUses(Local oldRes, Local newRes, Stmt stmt) {
        AssignStmt astmt = (AssignStmt)stmt;
        assert (astmt.getLeftOp() == oldRes);
        Set<Unit> usesOld = this.getUses(oldRes);
        if (usesOld != null) {
            for (Unit u : usesOld) {
                List<ValueBox> uselst = u.getUseBoxes();
                for (ValueBox vb : uselst) {
                    Value v = vb.getValue();
                    if (v != oldRes) continue;
                    vb.setValue(newRes);
                    this.remove(this.l2use, oldRes, stmt);
                    this.add(this.l2use, newRes, stmt);
                }
            }
            this.graph = new ExceptionalUnitGraph(this.body);
            this.sld = new SmartLocalDefs(this.graph, new SimpleLiveLocals(this.graph));
        }
        astmt.setLeftOp(newRes);
        this.remove(this.l2def, oldRes, stmt);
        this.add(this.l2def, newRes, stmt);
        return true;
    }
}

