/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.Model;
import edu.psu.cse.siis.coal.arguments.ArgumentValueManager;
import edu.psu.cse.siis.coal.arguments.LanguageConstraints;
import edu.psu.cse.siis.coal.arguments.MethodReturnValueAnalysis;
import edu.psu.cse.siis.coal.arguments.SourceMethodReturnValueAnalysis;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public class MethodReturnValueManager {
    private static final Map<String, MethodReturnValueAnalysis> methodReturnValueAnalysisMap = new HashMap<String, MethodReturnValueAnalysis>();
    private static final SourceMethodReturnValueAnalysis sourceMethodReturnValueAnalysis = new SourceMethodReturnValueAnalysis();
    private static final MethodReturnValueManager instance = new MethodReturnValueManager();

    private MethodReturnValueManager() {
    }

    public static MethodReturnValueManager v() {
        return instance;
    }

    public void registerMethodReturnValueAnalysis(String subSignature, MethodReturnValueAnalysis analysis) {
        methodReturnValueAnalysisMap.put(subSignature, analysis);
    }

    public void registerDefaultMethodReturnValueAnalyses() {
        this.registerMethodReturnValueAnalysis("java.lang.String getName()", new MethodReturnValueAnalysis(){

            @Override
            public Set<Object> computeMethodReturnValues(LanguageConstraints.Call call) {
                InvokeExpr invokeExpr = call.stmt.getInvokeExpr();
                if (invokeExpr instanceof InstanceInvokeExpr) {
                    InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
                    if (invokeExpr.getMethod().getDeclaringClass().getName().equals("java.lang.Class")) {
                        return ArgumentValueManager.v().getArgumentValueAnalysis("Class").computeVariableValues(instanceInvokeExpr.getBase(), call.stmt);
                    }
                }
                return null;
            }
        });
    }

    public Set<Object> getMethodReturnValues(LanguageConstraints.Call call) {
        Stmt stmt = call.stmt;
        if (!stmt.containsInvokeExpr()) {
            throw new RuntimeException("Statement does not contain invoke expression: " + stmt);
        }
        InvokeExpr invokeExpr = stmt.getInvokeExpr();
        MethodReturnValueAnalysis analysis = methodReturnValueAnalysisMap.get(invokeExpr.getMethod().getSubSignature());
        if (analysis != null) {
            return analysis.computeMethodReturnValues(call);
        }
        if (Model.v().getArgumentsForSource(invokeExpr) != null) {
            return sourceMethodReturnValueAnalysis.computeMethodReturnValues(call);
        }
        return null;
    }
}

