/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.cse.siis.coal.arguments;

import edu.psu.cse.siis.coal.arguments.CCVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NewExpr;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.jimple.internal.JSpecialInvokeExpr;
import soot.shimple.ShimpleBody;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

class MySmartLocalDefs {
    Map<Unit, Unit> unit2proxy;
    ExceptionalUnitGraph graph;
    SmartLocalDefs sld;

    MySmartLocalDefs(ExceptionalUnitGraph exceptionalUnitGraph) {
        this.graph = exceptionalUnitGraph;
        this.sld = new SmartLocalDefs(this.graph, new SimpleLiveLocals(this.graph));
        this.unit2proxy = new HashMap<Unit, Unit>();
        Body body = this.graph.getBody();
        assert (!(body instanceof ShimpleBody));
        for (Unit u : this.graph) {
            InvokeStmt iStmt;
            InvokeExpr iexpr;
            if (!(u instanceof InvokeStmt) || !MySmartLocalDefs.isSpecialInvokeHack(iexpr = (iStmt = (InvokeStmt)u).getInvokeExpr())) continue;
            Value vBase = ((JSpecialInvokeExpr)iexpr).getBase();
            assert (vBase instanceof Local);
            assert (vBase.getType().toString().equals("java.lang.StringBuilder") || vBase.getType().toString().equals("java.lang.String"));
            List<Unit> defs = this.sld.getDefsOfAt((Local)vBase, iStmt);
            assert (defs.size() == 1);
            Unit ud = defs.get(0);
            assert (ud != null);
            assert (ud instanceof DefinitionStmt);
            DefinitionStmt dStmt = (DefinitionStmt)ud;
            Value lop = dStmt.getLeftOp();
            Value rop = dStmt.getRightOp();
            assert (CCVisitor.isStringLike(lop));
            assert (rop instanceof NewExpr);
            this.unit2proxy.put(ud, iStmt);
        }
    }

    public List<Unit> getDefsOfAt(Local l, Unit s) {
        ArrayList<Unit> res = new ArrayList<Unit>();
        List<Unit> defs = this.sld.getDefsOfAt(l, s);
        for (Unit orig : defs) {
            Unit proxy = this.unit2proxy.get(orig);
            if (proxy != null && proxy != s) {
                res.add(proxy);
                continue;
            }
            res.add(orig);
        }
        return res;
    }

    static boolean isSpecialInvokeHack(Value v) {
        if (!(v instanceof JSpecialInvokeExpr)) {
            return false;
        }
        SootMethod sm = ((InvokeExpr)v).getMethod();
        String m_signature = sm.getSignature();
        return m_signature.startsWith("<java.lang.StringBuilder: void <init>(") || m_signature.startsWith("<java.lang.String: void <init>");
    }

    static boolean hasStringParameters(Value v) {
        if (!(v instanceof InvokeExpr)) {
            return false;
        }
        InvokeExpr iexpr = (InvokeExpr)v;
        SootMethod sm = iexpr.getMethod();
        String m_signature = sm.getSignature();
        return m_signature.contains("java.lang.String,") || m_signature.contains("java.lang.String)");
    }

    static boolean hasStringSideEffectHack(Value v) {
        if (!(v instanceof AbstractInstanceInvokeExpr)) {
            return false;
        }
        SootMethod sm = ((AbstractInstanceInvokeExpr)v).getMethod();
        String m_signature = sm.getSignature();
        return m_signature.startsWith("<java.lang.StringBuilder: java.lang.StringBuilder");
    }
}

